/*
 * Decompiled with CFR 0.152.
 */
package de.upb.eim.kiekerToPba;

import de.upb.eim.kiekerToPba.StackTraceBuilderAndPrinter;
import java.io.File;
import java.io.IOException;
import java.util.Scanner;
import kieker.analysis.AnalysisController;
import kieker.analysis.exception.AnalysisConfigurationException;
import kieker.analysis.plugin.reader.filesystem.FSReader;
import kieker.common.configuration.Configuration;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class Main {
    static String inputDir = null;

    public static void main(String[] args) throws IllegalStateException, AnalysisConfigurationException, IOException, ParseException {
        CommandLine argCmd = Main.parseCommandLine(args);
        if (argCmd.hasOption('i')) {
            inputDir = argCmd.getOptionValue('i');
        } else {
            System.out.print("Which conversion directory shall it be? ");
            Scanner inScan = new Scanner(System.in);
            inputDir = inScan.next();
        }
        if (inputDir.trim().equals(".") || inputDir.trim().replace('\\', '/').equals("./")) {
            inputDir = System.getProperty("user.dir");
        }
        AnalysisController analysisController = new AnalysisController();
        Configuration readerConfig = new Configuration();
        readerConfig.setProperty("inputDirs", inputDir);
        FSReader reader = new FSReader(readerConfig);
        analysisController.registerReader(reader);
        Configuration stackTracerConfig = new Configuration();
        stackTracerConfig.setProperty("CONFIG_OUTPUT_PATH", inputDir);
        StackTraceBuilderAndPrinter stbap = new StackTraceBuilderAndPrinter(stackTracerConfig);
        analysisController.registerFilter(stbap);
        analysisController.connect(reader, "monitoringRecords", stbap, "newEvent");
        analysisController.saveToFile(new File("out.kax"));
        analysisController.run();
    }

    private static CommandLine parseCommandLine(String[] args) throws ParseException {
        Options options = new Options();
        options.addOption("i", "inputDir", true, "input directory");
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        return cmd;
    }
}

