/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import kieker.analysis.exception.AnalysisConfigurationException;
import kieker.analysis.model.analysisMetaModel.MIDependency;
import kieker.analysis.model.analysisMetaModel.MIFilter;
import kieker.analysis.model.analysisMetaModel.MIInputPort;
import kieker.analysis.model.analysisMetaModel.MIOutputPort;
import kieker.analysis.model.analysisMetaModel.MIPlugin;
import kieker.analysis.model.analysisMetaModel.MIProject;
import kieker.analysis.model.analysisMetaModel.MIProperty;
import kieker.analysis.model.analysisMetaModel.MIRepository;
import kieker.analysis.model.analysisMetaModel.MIRepositoryConnector;
import kieker.analysis.model.analysisMetaModel.impl.MAnalysisMetaModelFactory;
import kieker.analysis.model.analysisMetaModel.impl.MAnalysisMetaModelPackage;
import kieker.analysis.plugin.AbstractPlugin;
import kieker.analysis.plugin.IPlugin;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.analysis.plugin.reader.AbstractReaderPlugin;
import kieker.analysis.plugin.reader.IReaderPlugin;
import kieker.analysis.repository.AbstractRepository;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnalysisController {
    private static final Log LOG = LogFactory.getLog(AnalysisController.class);
    private final String projectName;
    private final Collection<MIDependency> dependencies = new CopyOnWriteArrayList<MIDependency>();
    private final Collection<AbstractReaderPlugin> readers = new CopyOnWriteArrayList<AbstractReaderPlugin>();
    private final Collection<AbstractFilterPlugin> filters = new CopyOnWriteArrayList<AbstractFilterPlugin>();
    private final Collection<AbstractRepository> repos = new CopyOnWriteArrayList<AbstractRepository>();
    private final Collection<IStateObserver> stateObservers = new CopyOnWriteArrayList<IStateObserver>();
    private final CountDownLatch initializationLatch = new CountDownLatch(1);
    private Map<MIPlugin, AbstractPlugin> pluginModelMap;
    private Map<MIRepository, AbstractRepository> repositoryModelMap;
    private volatile STATE state = STATE.READY;

    public AnalysisController() {
        this.projectName = "AnalysisProject";
    }

    public AnalysisController(String projectName) {
        this.projectName = projectName;
    }

    public AnalysisController(File file) throws IOException, AnalysisConfigurationException {
        this(file, AnalysisController.class.getClassLoader());
    }

    public AnalysisController(File file, ClassLoader classLoader) throws IOException, AnalysisConfigurationException {
        this(AnalysisController.loadFromFile(file), classLoader);
    }

    public AnalysisController(MIProject project) throws NullPointerException, AnalysisConfigurationException {
        this(project, AnalysisController.class.getClassLoader());
    }

    public AnalysisController(MIProject project, ClassLoader classLoader) throws NullPointerException, AnalysisConfigurationException {
        if (project == null) {
            throw new NullPointerException("Can not load project null.");
        }
        this.loadFromModelProject(project, classLoader);
        this.projectName = project.getName();
    }

    public final void registerStateObserver(IStateObserver stateObserver) {
        this.stateObservers.add(stateObserver);
    }

    public final void unregisterStateObserver(IStateObserver stateObserver) {
        this.stateObservers.remove(stateObserver);
    }

    private final void notifyStateObservers() {
        STATE currState = this.state;
        for (IStateObserver observer : this.stateObservers) {
            observer.update(this, currState);
        }
    }

    private final void loadFromModelProject(MIProject mProject, ClassLoader classLoader) throws AnalysisConfigurationException {
        MAnalysisMetaModelFactory factory = new MAnalysisMetaModelFactory();
        for (MIDependency mDepdendency : mProject.getDependencies()) {
            MIDependency mDepdendencyCopy = factory.createDependency();
            mDepdendencyCopy.setFilePath(mDepdendency.getFilePath());
            this.dependencies.add(mDepdendencyCopy);
        }
        HashMap<MIRepository, AbstractRepository> repositoryMap = new HashMap<MIRepository, AbstractRepository>();
        for (MIRepository mRepository : mProject.getRepositories()) {
            Configuration configuration = AnalysisController.modelPropertiesToConfiguration(mRepository.getProperties());
            AbstractRepository repository = AnalysisController.createAndInitialize(AbstractRepository.class, mRepository.getClassname(), configuration, classLoader);
            repositoryMap.put(mRepository, repository);
            this.registerRepository(repository);
        }
        EList<MIPlugin> mPlugins = mProject.getPlugins();
        HashMap<MIPlugin, AbstractPlugin> pluginMap = new HashMap<MIPlugin, AbstractPlugin>();
        for (MIPlugin mPlugin : mPlugins) {
            Configuration configuration = AnalysisController.modelPropertiesToConfiguration(mPlugin.getProperties());
            String pluginClassname = mPlugin.getClassname();
            configuration.setProperty("name-hiddenAndNeverExportedProperty", mPlugin.getName());
            AbstractPlugin plugin = AnalysisController.createAndInitialize(AbstractPlugin.class, pluginClassname, configuration, classLoader);
            pluginMap.put(mPlugin, plugin);
            AnalysisController.checkConfiguration(plugin, configuration);
            if (plugin instanceof AbstractReaderPlugin) {
                this.registerReader((AbstractReaderPlugin)plugin);
                continue;
            }
            this.registerFilter((AbstractFilterPlugin)plugin);
        }
        for (MIPlugin mPlugin : mPlugins) {
            AnalysisController.checkPorts(mPlugin, (AbstractPlugin)pluginMap.get(mPlugin));
            EList<MIRepositoryConnector> mPluginRPorts = mPlugin.getRepositories();
            for (MIRepositoryConnector mPluginRPort : mPluginRPorts) {
                this.connect((AbstractPlugin)pluginMap.get(mPlugin), mPluginRPort.getName(), (AbstractRepository)repositoryMap.get(mPluginRPort.getRepository()));
            }
            EList<MIOutputPort> mPluginOPorts = mPlugin.getOutputPorts();
            for (MIOutputPort mPluginOPort : mPluginOPorts) {
                String outputPortName = mPluginOPort.getName();
                AbstractPlugin srcPlugin = (AbstractPlugin)pluginMap.get(mPlugin);
                EList<MIInputPort> mSubscribers = mPluginOPort.getSubscribers();
                for (MIInputPort mSubscriber : mSubscribers) {
                    String inputPortName = mSubscriber.getName();
                    AbstractPlugin dstPlugin = (AbstractPlugin)pluginMap.get(mSubscriber.getParent());
                    this.connect(srcPlugin, outputPortName, dstPlugin, inputPortName);
                }
            }
        }
        this.pluginModelMap = pluginMap;
        this.repositoryModelMap = repositoryMap;
    }

    private static void checkPorts(MIPlugin mPlugin, AbstractPlugin plugin) throws AnalysisConfigurationException {
        EList<MIOutputPort> mOutputPorts = mPlugin.getOutputPorts();
        HashSet<String> outputPorts = new HashSet<String>();
        for (String outputPort : plugin.getAllOutputPortNames()) {
            outputPorts.add(outputPort);
        }
        HashSet<String> inputPorts = new HashSet<String>();
        for (String inputPort : plugin.getAllInputPortNames()) {
            inputPorts.add(inputPort);
        }
        for (MIOutputPort mOutputPort : mOutputPorts) {
            if (outputPorts.contains(mOutputPort.getName())) continue;
            throw new AnalysisConfigurationException("The output port '" + mOutputPort.getName() + "' of '" + mPlugin.getName() + "' (" + mPlugin.getClassname() + ") does not exist.");
        }
        BasicEList mInputPorts = mPlugin instanceof MIFilter ? ((MIFilter)mPlugin).getInputPorts() : new BasicEList();
        for (MIInputPort mInputPort : mInputPorts) {
            if (inputPorts.contains(mInputPort.getName())) continue;
            throw new AnalysisConfigurationException("The input port '" + mInputPort.getName() + "' of '" + mPlugin.getName() + "' (" + mPlugin.getClassname() + ") does not exist.");
        }
    }

    private static void checkConfiguration(AbstractPlugin plugin, Configuration configuration) throws AnalysisConfigurationException {
        HashSet<String> possibleKeys = new HashSet<String>();
        Enumeration<?> e = plugin.getCurrentConfiguration().propertyNames();
        while (e.hasMoreElements()) {
            possibleKeys.add((String)e.nextElement());
        }
        e = configuration.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (possibleKeys.contains(key) || key.equals("name-hiddenAndNeverExportedProperty")) continue;
            throw new AnalysisConfigurationException("Invalid property of '" + plugin.getName() + "' (" + plugin.getPluginName() + ") found: '" + key + "'.");
        }
    }

    public final void saveToFile(File file) throws IOException, AnalysisConfigurationException {
        MIProject mProject = this.getCurrentConfiguration();
        AnalysisController.saveToFile(file, mProject);
    }

    public void connect(AbstractPlugin src, String outputPortName, AbstractPlugin dst, String inputPortName) throws IllegalStateException, AnalysisConfigurationException {
        if (this.state != STATE.READY) {
            throw new IllegalStateException("Unable to connect readers and filters after starting analysis.");
        }
        if (dst instanceof IReaderPlugin) {
            throw new AnalysisConfigurationException("The plugin '" + dst.getName() + "' (" + dst.getPluginName() + ") is a reader and can not be connected to.");
        }
        if (!this.filters.contains(src) && !this.readers.contains(src)) {
            throw new AnalysisConfigurationException("The plugin '" + src.getName() + "' (" + src.getPluginName() + ") is not registered.");
        }
        if (!this.filters.contains(dst)) {
            throw new AnalysisConfigurationException("The plugin '" + dst.getName() + "' (" + dst.getPluginName() + ") is not registered.");
        }
        AbstractPlugin.connect(src, outputPortName, dst, inputPortName);
    }

    public void connect(AbstractPlugin plugin, String repositoryPort, AbstractRepository repository) throws IllegalStateException, AnalysisConfigurationException {
        if (this.state != STATE.READY) {
            throw new IllegalStateException("Unable to connect repositories after starting analysis.");
        }
        if (!this.filters.contains(plugin) && !this.readers.contains(plugin)) {
            throw new AnalysisConfigurationException("The plugin '" + plugin.getName() + "' (" + plugin.getPluginName() + ") is not registered.");
        }
        if (!this.repos.contains(repository)) {
            throw new AnalysisConfigurationException("The repository '" + repository.getName() + "' (" + repository.getRepositoryName() + ") is not registered.");
        }
        plugin.connect(repositoryPort, repository);
    }

    private static List<MIProperty> convertProperties(Configuration configuration, MAnalysisMetaModelFactory factory) {
        if (null == configuration) {
            return Collections.emptyList();
        }
        ArrayList<MIProperty> properties = new ArrayList<MIProperty>(configuration.size());
        Enumeration<?> e = configuration.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            MIProperty property = factory.createProperty();
            property.setName(key);
            property.setValue(configuration.getStringProperty(key));
            properties.add(property);
        }
        return properties;
    }

    public final MIProject getCurrentConfiguration() throws AnalysisConfigurationException {
        try {
            MAnalysisMetaModelFactory factory = new MAnalysisMetaModelFactory();
            MIProject mProject = factory.createProject();
            mProject.setName(this.projectName);
            HashMap<AbstractPlugin, MIPlugin> pluginMap = new HashMap<AbstractPlugin, MIPlugin>();
            HashMap<AbstractRepository, MIRepository> repositoryMap = new HashMap<AbstractRepository, MIRepository>();
            mProject.getDependencies().addAll(this.dependencies);
            for (AbstractRepository repo : this.repos) {
                MIRepository mIRepository = factory.createRepository();
                mIRepository.setClassname(repo.getClass().getName());
                mIRepository.getProperties().addAll(AnalysisController.convertProperties(repo.getCurrentConfiguration(), factory));
                mProject.getRepositories().add((Object)mIRepository);
                repositoryMap.put(repo, mIRepository);
            }
            ArrayList<AbstractReaderPlugin> plugins = new ArrayList<AbstractReaderPlugin>(this.readers);
            for (AbstractFilterPlugin abstractFilterPlugin : this.filters) {
                plugins.add((AbstractReaderPlugin)((Object)abstractFilterPlugin));
            }
            for (AbstractPlugin abstractPlugin : plugins) {
                String[] ins;
                String[] outs;
                MIPlugin mPlugin = abstractPlugin instanceof AbstractReaderPlugin ? factory.createReader() : factory.createFilter();
                pluginMap.put(abstractPlugin, mPlugin);
                mPlugin.setClassname(abstractPlugin.getClass().getName());
                mPlugin.setName(abstractPlugin.getName());
                mPlugin.getProperties().addAll(AnalysisController.convertProperties(abstractPlugin.getCurrentConfiguration(), factory));
                for (Map.Entry<String, AbstractRepository> repoEntry : abstractPlugin.getCurrentRepositories().entrySet()) {
                    AbstractRepository repository = repoEntry.getValue();
                    MIRepository mRepository = (MIRepository)repositoryMap.get(repository);
                    if (mRepository == null) {
                        throw new AnalysisConfigurationException("Repository '" + repository.getName() + "' (" + repository.getRepositoryName() + ") not contained in project. Maybe the repository has not been registered.");
                    }
                    MIRepositoryConnector mRepositoryConn = factory.createRepositoryConnector();
                    mRepositoryConn.setName(repoEntry.getKey());
                    mRepositoryConn.setRepository(mRepository);
                    mPlugin.getRepositories().add((Object)mRepositoryConn);
                }
                for (String out : outs = abstractPlugin.getAllOutputPortNames()) {
                    MIOutputPort mOutputPort = factory.createOutputPort();
                    mOutputPort.setName(out);
                    mPlugin.getOutputPorts().add((Object)mOutputPort);
                }
                for (String in : ins = abstractPlugin.getAllInputPortNames()) {
                    MIInputPort mInputPort = factory.createInputPort();
                    mInputPort.setName(in);
                    ((MIFilter)mPlugin).getInputPorts().add((Object)mInputPort);
                }
                mProject.getPlugins().add((Object)mPlugin);
            }
            for (AbstractPlugin abstractPlugin : plugins) {
                MIPlugin mOutputPlugin = (MIPlugin)pluginMap.get(abstractPlugin);
                for (String outputPortName : abstractPlugin.getAllOutputPortNames()) {
                    EList<MIInputPort> subscribers = AnalysisController.findOutputPort(mOutputPlugin, outputPortName).getSubscribers();
                    for (IPlugin.PluginInputPortReference subscriber : abstractPlugin.getConnectedPlugins(outputPortName)) {
                        IPlugin subscriberPlugin = subscriber.getPlugin();
                        MIPlugin mSubscriberPlugin = (MIPlugin)pluginMap.get(subscriberPlugin);
                        if (mSubscriberPlugin == null) {
                            throw new AnalysisConfigurationException("Plugin '" + subscriberPlugin.getName() + "' (" + subscriberPlugin.getPluginName() + ") not contained in project. Maybe the plugin has not been registered.");
                        }
                        MIInputPort mInputPort = AnalysisController.findInputPort((MIFilter)mSubscriberPlugin, subscriber.getInputPortName());
                        subscribers.add((Object)mInputPort);
                    }
                }
            }
            return mProject;
        }
        catch (Exception ex) {
            throw new AnalysisConfigurationException("Failed to retrieve current configuration of AnalysisCopntroller.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() throws IllegalStateException, AnalysisConfigurationException {
        AnalysisController analysisController = this;
        synchronized (analysisController) {
            if (this.state != STATE.READY) {
                throw new IllegalStateException("AnalysisController may be executed only once.");
            }
            this.state = STATE.RUNNING;
            this.notifyStateObservers();
        }
        if (this.readers.size() == 0) {
            this.terminate(true);
            throw new AnalysisConfigurationException("No log reader registered.");
        }
        for (AbstractReaderPlugin reader : this.readers) {
            if (!reader.areAllRepositoryPortsConnected()) {
                this.terminate(true);
                throw new AnalysisConfigurationException("Reader '" + reader.getName() + "' (" + reader.getPluginName() + ") has unconnected repositories.");
            }
            if (reader.start()) continue;
            this.terminate(true);
            throw new AnalysisConfigurationException("Reader '" + reader.getName() + "' (" + reader.getPluginName() + ") failed to initialize.");
        }
        for (AbstractFilterPlugin filter : this.filters) {
            if (!filter.areAllRepositoryPortsConnected()) {
                this.terminate(true);
                throw new AnalysisConfigurationException("Plugin '" + filter.getName() + "' (" + filter.getPluginName() + ") has unconnected repositories.");
            }
            if (filter.start()) continue;
            this.terminate(true);
            throw new AnalysisConfigurationException("Plugin '" + filter.getName() + "' (" + filter.getPluginName() + ") failed to initialize.");
        }
        final CountDownLatch readerLatch = new CountDownLatch(this.readers.size());
        for (final AbstractReaderPlugin reader : this.readers) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        if (!reader.read()) {
                            LOG.error("Calling read() on Reader '" + reader.getName() + "' (" + reader.getPluginName() + ")  returned false.");
                            AnalysisController.this.terminate(true);
                        }
                    }
                    catch (Throwable t) {
                        LOG.error("Exception while reading on Reader '" + reader.getName() + "' (" + reader.getPluginName() + ").", t);
                        AnalysisController.this.terminate(true);
                    }
                    finally {
                        readerLatch.countDown();
                    }
                }
            }).start();
        }
        try {
            this.initializationLatch.countDown();
            readerLatch.await();
        }
        catch (InterruptedException ex) {
            LOG.warn("Interrupted while waiting for readers to finish", ex);
        }
        this.terminate();
    }

    protected final void awaitInitialization() {
        try {
            this.initializationLatch.await();
        }
        catch (InterruptedException ex) {
            LOG.warn("Interrupted while waiting for initialization of analysis controller.", ex);
        }
    }

    public final void terminate() {
        this.terminate(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void terminate(boolean error) {
        AnalysisController analysisController = this;
        synchronized (analysisController) {
            if (this.state != STATE.RUNNING) {
                return;
            }
            if (error) {
                LOG.info("Error during analysis. Terminating ...");
                this.state = STATE.FAILED;
                this.notifyStateObservers();
            } else {
                LOG.info("Terminating analysis.");
                this.state = STATE.TERMINATED;
                this.notifyStateObservers();
            }
        }
        for (AbstractReaderPlugin reader : this.readers) {
            reader.shutdown(error);
        }
        for (AbstractFilterPlugin filter : this.filters) {
            filter.shutdown(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerReader(AbstractReaderPlugin reader) throws IllegalStateException {
        if (this.state != STATE.READY) {
            throw new IllegalStateException("Unable to register filter after starting analysis.");
        }
        AnalysisController analysisController = this;
        synchronized (analysisController) {
            if (this.readers.contains(reader)) {
                LOG.warn("Readers " + reader.getName() + " already registered.");
                return;
            }
            this.readers.add(reader);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Registered reader " + reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerFilter(AbstractFilterPlugin filter) throws IllegalStateException {
        if (this.state != STATE.READY) {
            throw new IllegalStateException("Unable to register filter after starting analysis.");
        }
        AnalysisController analysisController = this;
        synchronized (analysisController) {
            if (this.filters.contains(filter)) {
                LOG.warn("Filter '" + filter.getName() + "' (" + filter.getPluginName() + ") already registered.");
                return;
            }
            this.filters.add(filter);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Registered plugin " + filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerRepository(AbstractRepository repository) throws IllegalStateException {
        if (this.state != STATE.READY) {
            throw new IllegalStateException("Unable to register respository after starting analysis.");
        }
        AnalysisController analysisController = this;
        synchronized (analysisController) {
            if (this.repos.contains(repository)) {
                LOG.warn("Repository '" + repository.getName() + "' (" + repository.getRepositoryName() + ") already registered.");
                return;
            }
            this.repos.add(repository);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Registered Repository '" + repository.getName() + "' (" + repository.getRepositoryName() + ")");
        }
    }

    public final String getProjectName() {
        return this.projectName;
    }

    public final Collection<AbstractReaderPlugin> getReaders() {
        return Collections.unmodifiableCollection(this.readers);
    }

    public final Collection<AbstractFilterPlugin> getFilters() {
        return Collections.unmodifiableCollection(this.filters);
    }

    public final Collection<AbstractRepository> getRepositories() {
        return Collections.unmodifiableCollection(this.repos);
    }

    public final STATE getState() {
        return this.state;
    }

    public static final MIProject loadFromFile(File file) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        MAnalysisMetaModelPackage.init();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new EcoreResourceFactoryImpl(){

            public Resource createResource(URI uri) {
                XMIResourceImpl resource = (XMIResourceImpl)super.createResource(uri);
                resource.getDefaultLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
                return resource;
            }
        });
        try {
            XMIResource resource = (XMIResource)resourceSet.getResource(URI.createFileURI((String)file.toString()), true);
            resource.load(Collections.EMPTY_MAP);
            EList content = resource.getContents();
            if (!content.isEmpty()) {
                return (MIProject)content.get(0);
            }
            throw new IOException("No project found in file '" + file.getAbsolutePath() + "'.");
        }
        catch (IOException ex) {
            IOException newEx = new IOException("Error loading file '" + file.getAbsolutePath() + "'.");
            newEx.initCause(ex);
            throw newEx;
        }
        catch (Exception ex) {
            IOException newEx = new IOException("The given file '" + file.getAbsolutePath() + "' is not a valid kax-configuration file.");
            newEx.initCause(ex);
            throw newEx;
        }
    }

    public static final void saveToFile(File file, MIProject project) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        Resource resource = resourceSet.createResource(URI.createFileURI((String)file.getAbsolutePath()));
        resource.getContents().add((Object)project);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        try {
            resource.save(options);
        }
        catch (IOException ex) {
            IOException newEx = new IOException("Unable to save configuration file '" + file.getAbsolutePath() + "'.");
            newEx.initCause(ex);
            throw newEx;
        }
    }

    private static final Configuration modelPropertiesToConfiguration(EList<MIProperty> mProperties) {
        Configuration configuration = new Configuration();
        for (MIProperty mProperty : mProperties) {
            configuration.setProperty(mProperty.getName(), mProperty.getValue());
        }
        return configuration;
    }

    private static final MIInputPort findInputPort(MIFilter mPlugin, String name) {
        for (MIInputPort port : mPlugin.getInputPorts()) {
            if (!port.getName().equals(name)) continue;
            return port;
        }
        return null;
    }

    private static final MIOutputPort findOutputPort(MIPlugin mPlugin, String name) {
        for (MIOutputPort port : mPlugin.getOutputPorts()) {
            if (!port.getName().equals(name)) continue;
            return port;
        }
        return null;
    }

    protected static final <C> C createAndInitialize(Class<C> c, String classname, Configuration configuration, ClassLoader classLoader) throws AnalysisConfigurationException {
        try {
            Class<?> clazz = Class.forName(classname, true, classLoader);
            if (c.isAssignableFrom(clazz)) {
                return (C)clazz.getConstructor(Configuration.class).newInstance(configuration);
            }
            throw new AnalysisConfigurationException("Class '" + classname + "' has to implement or extend '" + c.getSimpleName() + "'");
        }
        catch (ClassNotFoundException ex) {
            throw new AnalysisConfigurationException(c.getSimpleName() + ": Class '" + classname + "' not found", ex);
        }
        catch (NoSuchMethodException ex) {
            throw new AnalysisConfigurationException(c.getSimpleName() + ": Class '" + classname + "' has to implement a (public) constructor that accepts a single Configuration", ex);
        }
        catch (Exception ex) {
            throw new AnalysisConfigurationException(c.getSimpleName() + ": Failed to load class for name '" + classname + "'", ex);
        }
    }

    public static final AnalysisControllerWithMapping createAnalysisController(MIProject project, ClassLoader classLoader) throws NullPointerException, AnalysisConfigurationException {
        AnalysisController controller = new AnalysisController(project, classLoader);
        return new AnalysisControllerWithMapping(controller, controller.pluginModelMap, controller.repositoryModelMap);
    }

    public static interface IStateObserver {
        public void update(AnalysisController var1, STATE var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum STATE {
        READY,
        RUNNING,
        TERMINATED,
        FAILED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AnalysisControllerWithMapping {
        private final Map<MIPlugin, AbstractPlugin> pluginMap;
        private final Map<MIRepository, AbstractRepository> repositoryMap;
        private final AnalysisController controller;

        public AnalysisControllerWithMapping(AnalysisController controller, Map<MIPlugin, AbstractPlugin> pluginMap, Map<MIRepository, AbstractRepository> repositoryMap) {
            this.controller = controller;
            this.pluginMap = pluginMap;
            this.repositoryMap = repositoryMap;
        }

        public Map<MIPlugin, AbstractPlugin> getPluginMap() {
            return this.pluginMap;
        }

        public Map<MIRepository, AbstractRepository> getRepositoryMap() {
            return this.repositoryMap;
        }

        public AnalysisController getController() {
            return this.controller;
        }
    }
}

