/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import kieker.analysis.display.annotation.Display;
import kieker.analysis.exception.AnalysisConfigurationException;
import kieker.analysis.plugin.IPlugin;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.annotation.RepositoryPort;
import kieker.analysis.plugin.reader.IReaderPlugin;
import kieker.analysis.repository.AbstractRepository;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Plugin
public abstract class AbstractPlugin
implements IPlugin {
    public static final String CONFIG_NAME = "name-hiddenAndNeverExportedProperty";
    private static final Log LOG = LogFactory.getLog(AbstractPlugin.class);
    protected final Configuration configuration;
    private final ConcurrentHashMap<String, ConcurrentLinkedQueue<IPlugin.PluginInputPortReference>> registeredMethods;
    private final ConcurrentHashMap<String, AbstractRepository> registeredRepositories;
    private final Map<String, RepositoryPort> repositoryPorts;
    private final Map<String, OutputPort> outputPorts;
    private final Map<String, InputPort> inputPorts;
    private final String name;
    private final List<AbstractPlugin> incomingPlugins;
    private final List<AbstractPlugin> outgoingPlugins;
    private volatile IPlugin.STATE state = IPlugin.STATE.READY;

    public AbstractPlugin(Configuration configuration) {
        try {
            configuration.setDefaultConfiguration(this.getDefaultConfiguration());
        }
        catch (IllegalAccessException ex) {
            LOG.error("Unable to set plugin default properties", ex);
        }
        this.configuration = configuration;
        this.name = configuration.getStringProperty(CONFIG_NAME);
        this.repositoryPorts = new ConcurrentHashMap<String, RepositoryPort>();
        this.outputPorts = new ConcurrentHashMap<String, OutputPort>();
        Plugin annotation = this.getClass().getAnnotation(Plugin.class);
        for (RepositoryPort repositoryPort : annotation.repositoryPorts()) {
            if (this.repositoryPorts.put(repositoryPort.name(), repositoryPort) == null) continue;
            LOG.error("Two RepositoryPorts use the same name: " + repositoryPort.name());
        }
        for (Annotation annotation2 : annotation.outputPorts()) {
            if (this.outputPorts.put(annotation2.name(), (OutputPort)annotation2) == null) continue;
            LOG.error("Two OutputPorts use the same name: " + annotation2.name());
        }
        this.inputPorts = new ConcurrentHashMap<String, InputPort>();
        if (!(this instanceof IReaderPlugin)) {
            for (Method method : this.getClass().getMethods()) {
                InputPort inputPort = method.getAnnotation(InputPort.class);
                if (inputPort == null || this.inputPorts.put(inputPort.name(), inputPort) == null) continue;
                LOG.error("Two InputPorts use the same name: " + inputPort.name());
            }
        }
        this.registeredRepositories = new ConcurrentHashMap(this.repositoryPorts.size());
        this.registeredMethods = new ConcurrentHashMap();
        for (OutputPort outputPort : annotation.outputPorts()) {
            this.registeredMethods.put(outputPort.name(), new ConcurrentLinkedQueue());
        }
        this.incomingPlugins = new ArrayList<AbstractPlugin>(1);
        this.outgoingPlugins = new ArrayList<AbstractPlugin>(1);
    }

    protected final boolean deliver(String outputPortName, Object data) {
        if (this.state != IPlugin.STATE.RUNNING && this.state != IPlugin.STATE.TERMINATING || data == null) {
            return false;
        }
        OutputPort outputPort = this.outputPorts.get(outputPortName);
        if (outputPort == null) {
            return false;
        }
        Class<?>[] outTypes = outputPort.eventTypes();
        if (outTypes.length == 0) {
            outTypes = new Class[]{Object.class};
        }
        boolean outTypeMatch = false;
        for (Class<?> eventType : outTypes) {
            if (!eventType.isInstance(data)) continue;
            outTypeMatch = true;
            break;
        }
        if (!outTypeMatch) {
            return false;
        }
        ConcurrentLinkedQueue<IPlugin.PluginInputPortReference> registeredMethodsOfPort = this.registeredMethods.get(outputPortName);
        block4: for (IPlugin.PluginInputPortReference pluginInputPortReference : registeredMethodsOfPort) {
            Class<?>[] eventTypes = pluginInputPortReference.getEventTypes();
            if (eventTypes.length == 0) {
                eventTypes = new Class[]{Object.class};
            }
            for (Class<?> eventType : eventTypes) {
                if (!eventType.isAssignableFrom(data.getClass())) continue;
                try {
                    pluginInputPortReference.getInputPortMethod().invoke((Object)pluginInputPortReference.getPlugin(), data);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    LOG.warn("Caught exception when sending data from " + this.getClass().getName() + ": OutputPort " + outputPort.name() + " to " + pluginInputPortReference.getPlugin().getClass().getName() + "'s InputPort " + pluginInputPortReference.getInputPortMethod().getName(), cause);
                }
                catch (Exception e) {
                    LOG.error("Caught exception when invoking " + pluginInputPortReference.getPlugin().getClass().getName() + "'s InputPort " + pluginInputPortReference.getInputPortMethod().getName(), e);
                }
                continue block4;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void connect(String reponame, AbstractRepository repository) throws AnalysisConfigurationException {
        if (this.state != IPlugin.STATE.READY) {
            throw new AnalysisConfigurationException("Plugin: " + this.getClass().getName() + " final not in " + (Object)((Object)IPlugin.STATE.READY) + " this.state, but final in state " + (Object)((Object)this.state) + ".");
        }
        RepositoryPort port = this.repositoryPorts.get(reponame);
        if (port == null) {
            throw new AnalysisConfigurationException("Failed to connect plugin '" + this.getName() + "' (" + this.getPluginName() + ") to repository '" + repository.getName() + "' (" + repository.getRepositoryName() + "). Unknown repository port: " + reponame);
        }
        Class<? extends AbstractRepository> repositoryType = port.repositoryType();
        if (!repositoryType.isAssignableFrom(repository.getClass())) {
            throw new AnalysisConfigurationException("Failed to connect plugin '" + this.getName() + "' (" + this.getPluginName() + ") to repository '" + repository.getName() + "' (" + repository.getRepositoryName() + "). Expected RepositoryType: " + repositoryType.getName() + " Found: " + repository.getClass().getName());
        }
        AbstractPlugin abstractPlugin = this;
        synchronized (abstractPlugin) {
            if (this.registeredRepositories.containsKey(reponame)) {
                throw new AnalysisConfigurationException("Failed to connect plugin '" + this.getName() + "' (" + this.getPluginName() + ") to repository '" + repository.getName() + "' (" + repository.getRepositoryName() + "). RepositoryPort already connected: " + reponame);
            }
            this.registeredRepositories.put(reponame, repository);
        }
    }

    public static final void connect(AbstractPlugin src, String outputPortName, AbstractPlugin dst, String inputPortName) throws AnalysisConfigurationException {
        if (!AbstractPlugin.isConnectionAllowed(src, outputPortName, dst, inputPortName)) {
            throw new AnalysisConfigurationException("Failed to connect plugin '" + src.getName() + "' (" + src.getPluginName() + ") to plugin '" + dst.getName() + "' (" + dst.getPluginName() + ").");
        }
        for (final Method m : dst.getClass().getMethods()) {
            InputPort ip = m.getAnnotation(InputPort.class);
            if (ip == null || m.getParameterTypes().length != 1 || !ip.name().equals(inputPortName)) continue;
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    m.setAccessible(true);
                    return null;
                }
            });
            src.registeredMethods.get(outputPortName).add(new IPlugin.PluginInputPortReference(dst, inputPortName, m, dst.inputPorts.get(inputPortName).eventTypes()));
            src.outgoingPlugins.add(dst);
            dst.incomingPlugins.add(src);
            src.notifyNewOutgoingConnection(outputPortName, dst, inputPortName);
            dst.notifyNewIncomingConnection(inputPortName, src, outputPortName);
            return;
        }
        throw new AnalysisConfigurationException("Failed to connect plugin '" + src.getName() + "' (" + src.getPluginName() + ") to plugin '" + dst.getName() + "' (" + dst.getPluginName() + ").");
    }

    public static final boolean isConnectionAllowed(AbstractPlugin src, String output, AbstractPlugin dst, String input) {
        if (src == null || dst == null || dst instanceof IReaderPlugin) {
            LOG.warn("Plugins are invalid or null.");
            return false;
        }
        if (src.state != IPlugin.STATE.READY) {
            LOG.warn("Plugin: " + src.getClass().getName() + " not in " + (Object)((Object)IPlugin.STATE.READY) + " state, but in state " + (Object)((Object)src.state) + ".");
            return false;
        }
        if (dst.state != IPlugin.STATE.READY) {
            LOG.warn("Plugin: " + dst.getClass().getName() + " not in " + (Object)((Object)IPlugin.STATE.READY) + " state, but in state " + (Object)((Object)dst.state) + ".");
            return false;
        }
        OutputPort outputPort = src.outputPorts.get(output);
        if (outputPort == null) {
            LOG.warn("Output port does not exist. Plugin: " + src.getClass().getName() + "; output: " + output);
            return false;
        }
        InputPort inputPort = dst.inputPorts.get(input);
        if (inputPort == null) {
            LOG.warn("Input port does not exist. Plugin: " + dst.getClass().getName() + "; input: " + input);
            return false;
        }
        if (inputPort.eventTypes().length != 0) {
            Class<Object>[] outEventTypes = outputPort.eventTypes().length == 0 ? new Class[]{Object.class} : outputPort.eventTypes();
            for (Class<?> clazz : outEventTypes) {
                for (Class<?> dstEventType : inputPort.eventTypes()) {
                    if (!dstEventType.isInterface() && !clazz.isInterface() && !dstEventType.isAssignableFrom(clazz) && !clazz.isAssignableFrom(dstEventType)) continue;
                    return true;
                }
            }
            LOG.warn("Ports are not comaptible with eachother.");
            return false;
        }
        return true;
    }

    private final Configuration getDefaultConfiguration() {
        Property[] propertyAnnotations;
        Configuration defaultConfiguration = new Configuration();
        Plugin pluginAnnotation = this.getClass().getAnnotation(Plugin.class);
        for (Property property : propertyAnnotations = pluginAnnotation.configuration()) {
            defaultConfiguration.setProperty(property.name(), property.defaultValue());
        }
        return defaultConfiguration;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getPluginName() {
        String pluginName = this.getClass().getAnnotation(Plugin.class).name();
        if (pluginName.equals("")) {
            return this.getClass().getSimpleName();
        }
        return pluginName;
    }

    @Override
    public final String getPluginDescription() {
        return this.getClass().getAnnotation(Plugin.class).description();
    }

    public final boolean areAllRepositoryPortsConnected() {
        Iterator<String> repositoryNameIter = this.repositoryPorts.keySet().iterator();
        while (repositoryNameIter.hasNext()) {
            if (this.registeredRepositories.containsKey(repositoryNameIter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public final Map<String, AbstractRepository> getCurrentRepositories() {
        return Collections.unmodifiableMap(this.registeredRepositories);
    }

    protected final AbstractRepository getRepository(String reponame) {
        return this.registeredRepositories.get(reponame);
    }

    @Override
    public final String[] getAllOutputPortNames() {
        LinkedList<String> outputNames = new LinkedList<String>();
        Plugin annotation = this.getClass().getAnnotation(Plugin.class);
        for (OutputPort outputPort : annotation.outputPorts()) {
            outputNames.add(outputPort.name());
        }
        return outputNames.toArray(new String[outputNames.size()]);
    }

    @Override
    public final String[] getAllInputPortNames() {
        LinkedList<String> inputNames = new LinkedList<String>();
        for (Method method : this.getClass().getMethods()) {
            InputPort inputPort = method.getAnnotation(InputPort.class);
            if (inputPort == null || method.getParameterTypes().length != 1) continue;
            inputNames.add(inputPort.name());
        }
        return inputNames.toArray(new String[inputNames.size()]);
    }

    @Override
    public final String[] getAllDisplayNames() {
        LinkedList<String> displayNames = new LinkedList<String>();
        for (Method method : this.getClass().getMethods()) {
            Display display = method.getAnnotation(Display.class);
            if (display == null) continue;
            displayNames.add(display.name());
        }
        return displayNames.toArray(new String[displayNames.size()]);
    }

    public final String[] getAllRepositoryPortNames() {
        LinkedList<String> repositoryNames = new LinkedList<String>();
        Plugin annotation = this.getClass().getAnnotation(Plugin.class);
        for (RepositoryPort repositoryPort : annotation.repositoryPorts()) {
            repositoryNames.add(repositoryPort.name());
        }
        return repositoryNames.toArray(new String[repositoryNames.size()]);
    }

    @Override
    public final List<IPlugin.PluginInputPortReference> getConnectedPlugins(String outputPortName) {
        OutputPort outputPort = this.outputPorts.get(outputPortName);
        if (outputPort == null) {
            return null;
        }
        ArrayList<IPlugin.PluginInputPortReference> result = new ArrayList<IPlugin.PluginInputPortReference>();
        for (IPlugin.PluginInputPortReference ref : this.registeredMethods.get(outputPortName)) {
            result.add(ref);
        }
        return result;
    }

    @Override
    public final IPlugin.STATE getState() {
        return this.state;
    }

    public final boolean start() {
        if (this.state != IPlugin.STATE.READY) {
            return false;
        }
        this.state = IPlugin.STATE.RUNNING;
        return this.init();
    }

    public final void shutdown(boolean error) {
        if (this.state != IPlugin.STATE.READY && this.state != IPlugin.STATE.RUNNING) {
            return;
        }
        this.state = error ? IPlugin.STATE.FAILING : IPlugin.STATE.TERMINATING;
        for (AbstractPlugin plugin : this.incomingPlugins) {
            plugin.shutdown(error);
        }
        this.terminate(error);
        this.state = error ? IPlugin.STATE.FAILED : IPlugin.STATE.TERMINATED;
        for (AbstractPlugin plugin : this.outgoingPlugins) {
            plugin.shutdown(error);
        }
    }

    public Set<AbstractPlugin> getIncomingPlugins(boolean transitive) {
        HashSet<AbstractPlugin> knownIncomingPlugins = new HashSet<AbstractPlugin>();
        this.addIncomingPlugins(knownIncomingPlugins, transitive);
        return knownIncomingPlugins;
    }

    private void addIncomingPlugins(Set<AbstractPlugin> knownIncomingPlugins, boolean transitive) {
        for (AbstractPlugin plugin : this.incomingPlugins) {
            knownIncomingPlugins.add(plugin);
            if (!transitive) continue;
            plugin.addIncomingPlugins(knownIncomingPlugins, transitive);
        }
    }

    protected void notifyNewIncomingConnection(String inputPortName, AbstractPlugin connectedPlugin, String outputPortName) throws AnalysisConfigurationException {
    }

    protected void notifyNewOutgoingConnection(String outputPortName, AbstractPlugin connectedPlugin, String inputPortName) throws AnalysisConfigurationException {
    }
}

