/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.filter.forward;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Plugin(programmaticOnly=true, description="A filter collecting incoming objects in a list (mostly used in testing scenarios)", outputPorts={@OutputPort(name="outputObjects", eventTypes={Object.class}, description="Provides each incoming object")})
public class ListCollectionFilter<T>
extends AbstractFilterPlugin {
    public static final String INPUT_PORT_NAME = "inputObject";
    public static final String OUTPUT_PORT_NAME = "outputObjects";
    private final List<T> list = Collections.synchronizedList(new ArrayList());

    public ListCollectionFilter(Configuration configuration) {
        super(configuration);
    }

    @InputPort(name="inputObject")
    public void input(Object data) {
        this.list.add(data);
        super.deliver(OUTPUT_PORT_NAME, data);
    }

    public void clear() {
        this.list.clear();
    }

    public List<T> getList() {
        return new CopyOnWriteArrayList<Object>(this.list.toArray());
    }

    public int size() {
        return this.list.size();
    }

    @Override
    public Configuration getCurrentConfiguration() {
        return new Configuration();
    }
}

