/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.filter.select;

import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.controlflow.OperationExecutionRecord;
import kieker.common.record.flow.trace.AbstractTraceEvent;
import kieker.common.record.flow.trace.Trace;

@Plugin(description="A filter which filters incoming records based on their timestamps", outputPorts={@OutputPort(name="recordsWithinTimePeriod", description="Fowards records within the timeperiod", eventTypes={IMonitoringRecord.class}), @OutputPort(name="recordsOutsidePeriod", description="Forwards records out of the timeperiod", eventTypes={IMonitoringRecord.class})}, configuration={@Property(name="ignoreBeforeTimestamp", defaultValue="0"), @Property(name="ignoreAfterTimestamp", defaultValue="9223372036854775807")})
public final class TimestampFilter
extends AbstractFilterPlugin {
    public static final String INPUT_PORT_NAME_ANY_RECORD = "monitoringRecordsAny";
    public static final String INPUT_PORT_NAME_FLOW = "monitoringRecordsFlow";
    public static final String INPUT_PORT_NAME_EXECUTION = "monitoringRecordsExecution";
    public static final String INPUT_PORT_NAME_COMBINED = "monitoringRecordsCombined";
    public static final String OUTPUT_PORT_NAME_WITHIN_PERIOD = "recordsWithinTimePeriod";
    public static final String OUTPUT_PORT_NAME_OUTSIDE_PERIOD = "recordsOutsidePeriod";
    public static final String CONFIG_PROPERTY_NAME_IGNORE_BEFORE_TIMESTAMP = "ignoreBeforeTimestamp";
    public static final String CONFIG_PROPERTY_NAME_IGNORE_AFTER_TIMESTAMP = "ignoreAfterTimestamp";
    public static final String CONFIG_PROPERTY_VALUE_MAX_TIMESTAMP_S = "9223372036854775807";
    public static final String CONFIG_PROPERTY_VALUE_MIN_TIMESTAMP_S = "0";
    public static final long CONFIG_PROPERTY_VALUE_MAX_TIMESTAMP = Long.parseLong("9223372036854775807");
    public static final long CONFIG_PROPERTY_VALUE_MIN_TIMESTAMP = Long.parseLong("0");
    private final long ignoreBeforeTimestamp;
    private final long ignoreAfterTimestamp;

    public TimestampFilter(Configuration configuration) {
        super(configuration);
        this.ignoreBeforeTimestamp = configuration.getLongProperty(CONFIG_PROPERTY_NAME_IGNORE_BEFORE_TIMESTAMP);
        this.ignoreAfterTimestamp = configuration.getLongProperty(CONFIG_PROPERTY_NAME_IGNORE_AFTER_TIMESTAMP);
    }

    public final Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_IGNORE_BEFORE_TIMESTAMP, Long.toString(this.ignoreBeforeTimestamp));
        configuration.setProperty(CONFIG_PROPERTY_NAME_IGNORE_AFTER_TIMESTAMP, Long.toString(this.ignoreAfterTimestamp));
        return configuration;
    }

    private final boolean inRange(long timestamp) {
        return timestamp >= this.ignoreBeforeTimestamp && timestamp <= this.ignoreAfterTimestamp;
    }

    @InputPort(name="monitoringRecordsCombined", description="Receives records to be selected by timestamps, based on type-specific selectors", eventTypes={IMonitoringRecord.class})
    public void inputCombined(IMonitoringRecord record) {
        if (record instanceof OperationExecutionRecord) {
            this.inputOperationExecutionRecord((OperationExecutionRecord)record);
        } else if (record instanceof AbstractTraceEvent) {
            this.inputTraceEvent(record);
        } else {
            this.inputIMonitoringRecord(record);
        }
    }

    @InputPort(name="monitoringRecordsAny", description="Receives records to be selected by their logging timestamps", eventTypes={IMonitoringRecord.class})
    public final void inputIMonitoringRecord(IMonitoringRecord record) {
        if (this.inRange(record.getLoggingTimestamp())) {
            super.deliver(OUTPUT_PORT_NAME_WITHIN_PERIOD, record);
        } else {
            super.deliver(OUTPUT_PORT_NAME_OUTSIDE_PERIOD, record);
        }
    }

    @InputPort(name="monitoringRecordsFlow", description="Receives trace events to be selected by a specific timestamp selector", eventTypes={AbstractTraceEvent.class, Trace.class})
    public final void inputTraceEvent(IMonitoringRecord record) {
        long timestamp;
        if (record instanceof Trace) {
            timestamp = ((Trace)record).getLoggingTimestamp();
        } else if (record instanceof AbstractTraceEvent) {
            timestamp = ((AbstractTraceEvent)record).getTimestamp();
        } else {
            return;
        }
        if (this.inRange(timestamp)) {
            super.deliver(OUTPUT_PORT_NAME_WITHIN_PERIOD, record);
        } else {
            super.deliver(OUTPUT_PORT_NAME_OUTSIDE_PERIOD, record);
        }
    }

    @InputPort(name="monitoringRecordsExecution", description="Receives trace events to be selected by a specific timestamp selector (based on tin and tout)", eventTypes={OperationExecutionRecord.class})
    public final void inputOperationExecutionRecord(OperationExecutionRecord execution) {
        if (this.inRange(execution.getTin()) && this.inRange(execution.getTout())) {
            super.deliver(OUTPUT_PORT_NAME_WITHIN_PERIOD, execution);
        } else {
            super.deliver(OUTPUT_PORT_NAME_OUTSIDE_PERIOD, execution);
        }
    }
}

