/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.repository;

import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.repository.IRepository;
import kieker.analysis.repository.annotation.Repository;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;

@Repository
public abstract class AbstractRepository
implements IRepository {
    public static final String CONFIG_NAME = "name-hiddenAndNeverExportedProperty";
    private static final Log LOG = LogFactory.getLog(AbstractRepository.class);
    protected final Configuration configuration;
    private final String name;

    public AbstractRepository(Configuration configuration) {
        try {
            configuration.setDefaultConfiguration(this.getDefaultConfiguration());
        }
        catch (IllegalAccessException ex) {
            LOG.error("Unable to set repository default properties");
        }
        this.configuration = configuration;
        this.name = configuration.getStringProperty(CONFIG_NAME);
    }

    protected final Configuration getDefaultConfiguration() {
        Property[] propertyAnnotations;
        Configuration defaultConfiguration = new Configuration();
        Repository repoAnnotation = this.getClass().getAnnotation(Repository.class);
        for (Property property : propertyAnnotations = repoAnnotation.configuration()) {
            defaultConfiguration.setProperty(property.name(), property.defaultValue());
        }
        return defaultConfiguration;
    }

    public final String getRepositoryName() {
        String repositoryName = this.getClass().getAnnotation(Repository.class).name();
        if (repositoryName.equals("")) {
            return this.getClass().getSimpleName();
        }
        return repositoryName;
    }

    public final String getRepositoryDescription() {
        return this.getClass().getAnnotation(Repository.class).description();
    }

    public final String getName() {
        return this.name;
    }
}

