/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.logging;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.TimeZone;
import java.util.concurrent.ArrayBlockingQueue;
import kieker.common.logging.Log;

public final class LogImplWebguiLogging
implements Log {
    private static final int MAX_ENTRIES = 100;
    private static final Map<String, Queue<String>> QUEUES = new HashMap<String, Queue<String>>();
    private final DateFormat date;
    private final String name;

    protected LogImplWebguiLogging(String name) {
        this.name = name;
        this.date = new SimpleDateFormat("yyyyMMdd'-'HHmmssSSS", Locale.US);
        this.date.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public boolean isDebugEnabled() {
        return false;
    }

    public void debug(String message) {
    }

    public void debug(String message, Throwable t) {
    }

    public void info(String message) {
        this.addMessage(message, "[Info]", null);
    }

    public void info(String message, Throwable t) {
        this.addMessage(message, "[Info]", t);
    }

    public void warn(String message) {
        this.addMessage(message, "[Warn]", null);
    }

    public void warn(String message, Throwable t) {
        this.addMessage(message, "[Warn]", t);
    }

    public void error(String message) {
        this.addMessage(message, "[Crit]", null);
    }

    public void error(String message, Throwable t) {
        this.addMessage(message, "[Crit]", t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMessage(String message, String severity, Throwable throwable) {
        Queue<String> queue;
        Object object = QUEUES;
        synchronized (object) {
            queue = QUEUES.get(this.name);
            if (queue == null) {
                queue = new ArrayBlockingQueue<String>(100);
                QUEUES.put(this.name, queue);
            }
        }
        object = queue;
        synchronized (object) {
            if (queue.size() >= 100) {
                queue.poll();
            }
            StringBuilder sb = new StringBuilder(255);
            sb.append(this.date.format(new Date()));
            sb.append(": ");
            sb.append(severity);
            sb.append(' ');
            sb.append(message);
            if (null != throwable) {
                sb.append('\n');
                sb.append(throwable.toString());
            }
            queue.add(sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, Queue<String>> map = QUEUES;
        synchronized (map) {
            QUEUES.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getEntries(String name) {
        Queue<String> queue;
        Object object = QUEUES;
        synchronized (object) {
            queue = QUEUES.get(name);
            if (queue == null) {
                return new String[0];
            }
        }
        object = queue;
        synchronized (object) {
            return queue.toArray(new String[queue.size()]);
        }
    }
}

