/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.namedRecordPipe;

import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.namedRecordPipe.IPipeReader;
import kieker.common.record.IMonitoringRecord;

public final class Pipe {
    private static final Log LOG = LogFactory.getLog(Pipe.class);
    private final String name;
    private volatile IPipeReader pipeReader;
    private volatile boolean closed;

    public Pipe(String name) {
        this.name = name;
    }

    public void setPipeReader(IPipeReader pipeReader) {
        this.pipeReader = pipeReader;
        if (LOG.isDebugEnabled()) {
            LOG.debug("PipeReader initialized");
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean writeMonitoringRecord(IMonitoringRecord monitoringRecord) {
        if (this.closed) {
            LOG.error("trying to write to closed pipe");
            return false;
        }
        if (this.pipeReader == null) {
            LOG.error("pipeReader is null, i.e., no pipe reader has been registered.");
            return false;
        }
        return this.pipeReader.newMonitoringRecord(monitoringRecord);
    }

    public void close() {
        this.closed = true;
        if (this.pipeReader != null) {
            this.pipeReader.notifyPipeClosed();
        }
    }
}

