/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.trace;

import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.flow.IFlowRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Trace
extends AbstractMonitoringRecord
implements IMonitoringRecord.Factory,
IFlowRecord {
    public static final String NO_SESSION_ID = "<no-session-id>";
    public static final String NO_HOSTNAME = "<default-host>";
    public static final long NO_PARENT_TRACEID = -1L;
    public static final int NO_PARENT_ORDER_INDEX = -1;
    private static final long serialVersionUID = -4734457252539987221L;
    private static final Class<?>[] TYPES = new Class[]{Long.TYPE, Long.TYPE, String.class, String.class, Long.TYPE, Integer.TYPE};
    private final long traceId;
    private final long threadId;
    private final String sessionId;
    private final String hostname;
    private final long parentTraceId;
    private final int parentOrderId;
    private transient int nextOrderId = 0;

    public Trace(long traceId, long threadId, String sessionId, String hostname, long parentTraceId, int parentOrderId) {
        this.traceId = traceId;
        this.threadId = threadId;
        this.sessionId = sessionId == null ? NO_SESSION_ID : sessionId;
        this.hostname = hostname == null ? NO_HOSTNAME : hostname;
        this.parentTraceId = parentTraceId;
        this.parentOrderId = parentOrderId;
    }

    public Trace(Object[] values) {
        AbstractMonitoringRecord.checkArray(values, TYPES);
        this.traceId = (Long)values[0];
        this.threadId = (Long)values[1];
        this.sessionId = (String)values[2];
        this.hostname = (String)values[3];
        this.parentTraceId = (Long)values[4];
        this.parentOrderId = (Integer)values[5];
    }

    @Override
    public final Object[] toArray() {
        return new Object[]{this.traceId, this.threadId, this.sessionId, this.hostname, this.parentTraceId, this.parentOrderId};
    }

    @Override
    public final Class<?>[] getValueTypes() {
        return (Class[])TYPES.clone();
    }

    @Override
    @Deprecated
    public final void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    public final long getTraceId() {
        return this.traceId;
    }

    public final long getThreadId() {
        return this.threadId;
    }

    public final String getSessionId() {
        return this.sessionId;
    }

    public final String getHostname() {
        return this.hostname;
    }

    public final long getParentTraceId() {
        return this.parentTraceId;
    }

    public final int getParentOrderId() {
        return this.parentOrderId;
    }

    public final int getNextOrderId() {
        return this.nextOrderId++;
    }
}

