/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.core.sampler;

import java.util.concurrent.ScheduledFuture;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.sampler.ISampler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduledSamplerJob
implements Runnable {
    private final IMonitoringController monitoringController;
    private final ISampler sampler;
    private volatile ScheduledFuture<?> future;

    public ScheduledSamplerJob(IMonitoringController monitoringController, ISampler sensor) {
        this.monitoringController = monitoringController;
        this.sampler = sensor;
    }

    @Override
    public final void run() throws RuntimeException {
        try {
            if (!this.monitoringController.isMonitoringEnabled()) {
                return;
            }
            this.sampler.sample(this.monitoringController);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public void setFuture(ScheduledFuture<?> future) {
        this.future = future;
    }

    public ScheduledFuture<?> getFuture() {
        return this.future;
    }
}

