/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.timer;

import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.monitoring.core.configuration.ConfigurationFactory;
import kieker.monitoring.timer.AbstractTimeSource;
import kieker.monitoring.timer.ITimeSource;

public final class SystemNanoTimer
extends AbstractTimeSource {
    public static final String CONFIG_OFFSET = SystemNanoTimer.class.getName() + ".offset";
    public static final String CONFIG_UNIT = SystemNanoTimer.class.getName() + ".unit";
    private static final Log LOG = LogFactory.getLog(SystemNanoTimer.class);
    private final long offset;
    private final long clockdifference = System.nanoTime() - TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
    private final TimeUnit timeunit;

    public SystemNanoTimer(Configuration configuration) {
        super(configuration);
        this.offset = configuration.getStringProperty(CONFIG_OFFSET).length() == 0 ? System.nanoTime() : this.clockdifference + configuration.getLongProperty(CONFIG_OFFSET);
        int timeunitval = configuration.getIntProperty(CONFIG_UNIT);
        switch (timeunitval) {
            case 0: {
                this.timeunit = TimeUnit.NANOSECONDS;
                break;
            }
            case 1: {
                this.timeunit = TimeUnit.MICROSECONDS;
                break;
            }
            case 2: {
                this.timeunit = TimeUnit.MILLISECONDS;
                break;
            }
            case 3: {
                this.timeunit = TimeUnit.SECONDS;
                break;
            }
            default: {
                LOG.warn("Failed to determine value of " + CONFIG_UNIT + " (0, 1, 2, or 3 expected). Setting to 0=nanoseconds");
                this.timeunit = TimeUnit.NANOSECONDS;
            }
        }
    }

    public final long getTime() {
        return this.timeunit.convert(System.nanoTime() - this.offset, TimeUnit.NANOSECONDS);
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Time in " + this.timeunit.toString().toLowerCase(Locale.ENGLISH) + " (with nanoseconds precision) since ");
        sb.append(new Date(TimeUnit.NANOSECONDS.toMillis(this.offset - this.clockdifference)));
        return sb.toString();
    }

    public static final ITimeSource getInstance() {
        return LazyHolder.INSTANCE;
    }

    private static final class LazyHolder {
        private static final ITimeSource INSTANCE = new SystemNanoTimer(ConfigurationFactory.createDefaultConfiguration().getPropertiesStartingWith(SystemNanoTimer.class.getName()));

        private LazyHolder() {
        }
    }
}

