/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer;

import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.IMonitoringRecord;
import kieker.monitoring.writer.AbstractAsyncThread;
import kieker.monitoring.writer.AbstractMonitoringWriter;

public abstract class AbstractAsyncWriter
extends AbstractMonitoringWriter {
    public static final String CONFIG_QUEUESIZE = "QueueSize";
    public static final String CONFIG_BEHAVIOR = "QueueFullBehavior";
    public static final String CONFIG_SHUTDOWNDELAY = "MaxShutdownDelay";
    private static final Log LOG = LogFactory.getLog(AbstractAsyncWriter.class);
    protected final BlockingQueue<IMonitoringRecord> blockingQueue;
    private final List<AbstractAsyncThread> workers = new CopyOnWriteArrayList<AbstractAsyncThread>();
    private final int queueFullBehavior;
    private final int maxShutdownDelay;
    private final AtomicInteger missedRecords;

    protected AbstractAsyncWriter(Configuration configuration) {
        super(configuration);
        String prefix = this.getClass().getName() + ".";
        int queueFullBehaviorTmp = this.configuration.getIntProperty(prefix + CONFIG_BEHAVIOR);
        if (queueFullBehaviorTmp < 0 || queueFullBehaviorTmp > 2) {
            LOG.warn("Unknown value '" + queueFullBehaviorTmp + "' for " + prefix + CONFIG_BEHAVIOR + "; using default value 0");
            this.queueFullBehavior = 0;
        } else {
            this.queueFullBehavior = queueFullBehaviorTmp;
        }
        this.missedRecords = new AtomicInteger(0);
        this.blockingQueue = new ArrayBlockingQueue<IMonitoringRecord>(this.configuration.getIntProperty(prefix + CONFIG_QUEUESIZE));
        this.maxShutdownDelay = this.configuration.getIntProperty(prefix + CONFIG_SHUTDOWNDELAY);
    }

    protected Configuration getDefaultConfiguration() {
        Configuration configuration = new Configuration(super.getDefaultConfiguration());
        String prefix = this.getClass().getName() + ".";
        configuration.setProperty(prefix + CONFIG_QUEUESIZE, "10000");
        configuration.setProperty(prefix + CONFIG_BEHAVIOR, "0");
        configuration.setProperty(prefix + CONFIG_SHUTDOWNDELAY, "-1");
        return configuration;
    }

    protected final void addWorker(AbstractAsyncThread worker) {
        this.workers.add(worker);
        worker.setDaemon(true);
        worker.start();
    }

    public final void terminate() {
        CountDownLatch cdl = new CountDownLatch(this.workers.size());
        for (AbstractAsyncThread worker : this.workers) {
            worker.initShutdown(cdl);
        }
        boolean finished = false;
        try {
            if (this.maxShutdownDelay > -1) {
                LOG.info("Shutting down writers, waiting at most " + this.maxShutdownDelay + " milliseconds.");
                finished = cdl.await(this.maxShutdownDelay, TimeUnit.MILLISECONDS);
            } else {
                LOG.info("Shutting down writers.");
                cdl.await();
                finished = true;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (finished) {
            LOG.info("Writer shutdown complete.");
        } else {
            LOG.info("Writer shutdown incomplete, " + cdl.getCount() + " worker(s) halted.");
        }
    }

    public final boolean newMonitoringRecord(IMonitoringRecord monitoringRecord) {
        try {
            switch (this.queueFullBehavior) {
                case 1: {
                    this.blockingQueue.put(monitoringRecord);
                    break;
                }
                case 2: {
                    if (!this.blockingQueue.offer(monitoringRecord) && this.missedRecords.getAndIncrement() % 1000 == 0) {
                        LOG.warn("Queue is full, dropping records.");
                    }
                    break;
                }
                default: {
                    this.blockingQueue.add(monitoringRecord);
                    break;
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Failed to retrieve new monitoring record.", ex);
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(super.toString());
        sb.append("\n\tRecords lost: ");
        sb.append(this.missedRecords.intValue());
        sb.append("\n\tWriter Threads (");
        sb.append(this.workers.size());
        sb.append("): ");
        for (AbstractAsyncThread worker : this.workers) {
            sb.append("\n\t\t");
            sb.append(worker.toString());
        }
        return sb.toString();
    }
}

