/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import kieker.common.configuration.Configuration;
import kieker.common.exception.MonitoringRecordException;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.IMonitoringRecord;
import kieker.monitoring.writer.AbstractMonitoringWriter;
import kieker.monitoring.writer.database.DBWriterHelper;

public final class SyncDbWriter
extends AbstractMonitoringWriter {
    private static final String PREFIX = SyncDbWriter.class.getName() + ".";
    public static final String CONFIG_DRIVERCLASSNAME = PREFIX + "DriverClassname";
    public static final String CONFIG_CONNECTIONSTRING = PREFIX + "ConnectionString";
    public static final String CONFIG_TABLEPREFIX = PREFIX + "TablePrefix";
    public static final String CONFIG_OVERWRITE = PREFIX + "DropTables";
    private static final Log LOG = LogFactory.getLog(SyncDbWriter.class);
    private final Connection connection;
    private final DBWriterHelper helper;
    private final Map<Class<? extends IMonitoringRecord>, PreparedStatement> recordTypeInformation = new ConcurrentHashMap<Class<? extends IMonitoringRecord>, PreparedStatement>();
    private final AtomicLong recordId = new AtomicLong();

    public SyncDbWriter(Configuration configuration) throws Exception {
        super(configuration);
        try {
            Class.forName(configuration.getStringProperty(CONFIG_DRIVERCLASSNAME)).newInstance();
        }
        catch (Exception ex) {
            throw new Exception("DB driver registration failed. Perhaps the driver jar is missing?", ex);
        }
        try {
            this.connection = DriverManager.getConnection(configuration.getStringProperty(CONFIG_CONNECTIONSTRING));
            this.helper = new DBWriterHelper(this.connection, configuration.getStringProperty(CONFIG_TABLEPREFIX), configuration.getBooleanProperty(CONFIG_OVERWRITE));
            this.helper.createIndexTable();
        }
        catch (SQLException ex) {
            throw new Exception("SQLException with SQLState: '" + ex.getSQLState() + "' and VendorError: '" + ex.getErrorCode() + "'", ex);
        }
    }

    public final void init() throws Exception {
    }

    public final boolean newMonitoringRecord(IMonitoringRecord record) {
        Class<?> recordClass = record.getClass();
        String recordClassName = recordClass.getSimpleName();
        if (!this.recordTypeInformation.containsKey(recordClass)) {
            Class<?>[] typeArray;
            if (LOG.isDebugEnabled()) {
                LOG.debug("New record type found: " + recordClassName);
            }
            try {
                typeArray = AbstractMonitoringRecord.typesForClass(recordClass);
            }
            catch (MonitoringRecordException ex) {
                LOG.error("Failed to get types of record", ex);
                return false;
            }
            try {
                String tableName = this.helper.createTable(recordClass.getName(), typeArray);
                StringBuilder sb = new StringBuilder("?,?");
                for (int count = typeArray.length; count > 0; --count) {
                    sb.append(",?");
                }
                PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO " + tableName + " VALUES (" + sb.toString() + ")");
                this.recordTypeInformation.put(recordClass, preparedStatement);
            }
            catch (SQLException ex) {
                LOG.error("SQLException with SQLState: '" + ex.getSQLState() + "' and VendorError: '" + ex.getErrorCode() + "'", ex);
                return false;
            }
        }
        try {
            long id = this.recordId.getAndIncrement();
            PreparedStatement preparedStatement = this.recordTypeInformation.get(recordClass);
            preparedStatement.setLong(1, id);
            preparedStatement.setLong(2, record.getLoggingTimestamp());
            Object[] recordFields = record.toArray();
            for (int i = 0; i < recordFields.length; ++i) {
                if (this.helper.set(preparedStatement, i + 3, recordFields[i])) continue;
                return false;
            }
            preparedStatement.executeUpdate();
        }
        catch (SQLException ex) {
            LOG.error("SQLException with SQLState: '" + ex.getSQLState() + "' and VendorError: '" + ex.getErrorCode() + "'", ex);
            return false;
        }
        return true;
    }

    public void terminate() {
        try {
            for (Class<? extends IMonitoringRecord> recordType : this.recordTypeInformation.keySet()) {
                PreparedStatement preparedStatement = this.recordTypeInformation.remove(recordType);
                if (preparedStatement == null) continue;
                preparedStatement.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException ex) {
            LOG.error("SQLException with SQLState: '" + ex.getSQLState() + "' and VendorError: '" + ex.getErrorCode() + "'", ex);
        }
        LOG.info("Writer: SyncDbWriter shutdown complete");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(super.toString());
        sb.append("\n\tConnection: '");
        sb.append(this.connection.toString());
        sb.append("'\n\t");
        sb.append(this.helper.toString());
        return sb.toString();
    }
}

