/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.filesystem;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.BlockingQueue;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.writer.AbstractAsyncWriter;
import kieker.monitoring.writer.filesystem.MappingFileWriter;
import kieker.monitoring.writer.filesystem.async.AbstractFsWriterThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAsyncFSWriter
extends AbstractAsyncWriter {
    public static final String CONFIG_PATH = "customStoragePath";
    public static final String CONFIG_TEMP = "storeInJavaIoTmpdir";
    public static final String CONFIG_MAXENTRIESINFILE = "maxEntriesInFile";
    public static final String CONFIG_MAXLOGSIZE = "maxLogSize";
    public static final String CONFIG_MAXLOGFILES = "maxLogFiles";
    private static final String PATH_PREFIX = "kieker-";

    protected AbstractAsyncFSWriter(Configuration configuration) {
        super(configuration);
    }

    @Override
    protected Configuration getDefaultConfiguration() {
        Configuration configuration = new Configuration(super.getDefaultConfiguration());
        String prefix = this.getClass().getName() + ".";
        configuration.setProperty(prefix + CONFIG_PATH, ".");
        configuration.setProperty(prefix + CONFIG_TEMP, "true");
        configuration.setProperty(prefix + CONFIG_MAXENTRIESINFILE, "25000");
        configuration.setProperty(prefix + CONFIG_MAXLOGSIZE, "-1");
        configuration.setProperty(prefix + CONFIG_MAXLOGFILES, "-1");
        return configuration;
    }

    @Override
    protected final void init() throws Exception {
        String prefix = this.getClass().getName() + '.';
        String path = this.configuration.getBooleanProperty(prefix + CONFIG_TEMP) ? System.getProperty("java.io.tmpdir") : this.configuration.getStringProperty(prefix + CONFIG_PATH);
        File f = new File(path);
        if (!f.isDirectory()) {
            throw new IllegalArgumentException("'" + path + "' is not a directory.");
        }
        String ctrlName = this.monitoringController.getHostname() + "-" + this.monitoringController.getName();
        SimpleDateFormat date = new SimpleDateFormat("yyyyMMdd'-'HHmmssSSS", Locale.US);
        date.setTimeZone(TimeZone.getTimeZone("UTC"));
        String dateStr = date.format(new Date());
        StringBuffer sb = new StringBuffer(path.length() + PATH_PREFIX.length() + ctrlName.length() + 25);
        sb.append(path).append(File.separatorChar).append(PATH_PREFIX).append(dateStr).append("-UTC-").append(ctrlName).append(File.separatorChar);
        path = sb.toString();
        f = new File(path);
        if (!f.mkdir()) {
            throw new IllegalArgumentException("Failed to create directory '" + path + "'");
        }
        int maxEntriesInFile = this.configuration.getIntProperty(prefix + CONFIG_MAXENTRIESINFILE);
        if (maxEntriesInFile < 1) {
            throw new IllegalArgumentException(prefix + CONFIG_MAXENTRIESINFILE + " must be greater than 0 but is '" + maxEntriesInFile + "'");
        }
        int maxlogSize = this.configuration.getIntProperty(prefix + CONFIG_MAXLOGSIZE);
        int maxLogFiles = this.configuration.getIntProperty(prefix + CONFIG_MAXLOGFILES);
        MappingFileWriter mappingFileWriter = new MappingFileWriter(path);
        this.addWorker(this.initWorker(this.monitoringController, this.blockingQueue, mappingFileWriter, path, maxEntriesInFile, maxlogSize, maxLogFiles));
    }

    protected abstract AbstractFsWriterThread initWorker(IMonitoringController var1, BlockingQueue<IMonitoringRecord> var2, MappingFileWriter var3, String var4, int var5, int var6, int var7);
}

