/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.filesystem.async;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.IMonitoringRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.writer.filesystem.MappingFileWriter;
import kieker.monitoring.writer.filesystem.async.AbstractFsWriterThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryFsWriterThread
extends AbstractFsWriterThread {
    private static final Log LOG = LogFactory.getLog(BinaryFsWriterThread.class);
    private DataOutputStream out;

    public BinaryFsWriterThread(IMonitoringController monitoringController, BlockingQueue<IMonitoringRecord> writeQueue, MappingFileWriter mappingFileWriter, String path, int maxEntriesInFile, int maxLogSize, int maxLogFiles) {
        super(monitoringController, writeQueue, mappingFileWriter, path, maxEntriesInFile, maxLogSize, maxLogFiles);
        this.fileExtension = ".bin";
    }

    @Override
    protected void write(IMonitoringRecord monitoringRecord) throws IOException {
        this.out.writeInt(this.monitoringController.getIdForString(monitoringRecord.getClass().getName()));
        this.out.writeLong(monitoringRecord.getLoggingTimestamp());
        Object[] recordFields = monitoringRecord.toArray();
        for (int i = 0; i < recordFields.length; ++i) {
            if (recordFields[i] == null) {
                Class<?>[] recordTypes = monitoringRecord.getValueTypes();
                if (recordTypes[i] == String.class) {
                    this.out.writeInt(this.monitoringController.getIdForString(""));
                    continue;
                }
                if (recordTypes[i] == Integer.class) {
                    this.out.writeInt(0);
                    continue;
                }
                if (recordTypes[i] == Long.class) {
                    this.out.writeLong(0L);
                    continue;
                }
                if (recordTypes[i] == Float.class) {
                    this.out.writeFloat(0.0f);
                    continue;
                }
                if (recordTypes[i] == Double.class) {
                    this.out.writeDouble(0.0);
                    continue;
                }
                if (recordTypes[i] == Byte.class) {
                    this.out.writeByte(0);
                    continue;
                }
                if (recordTypes[i] == Short.class) {
                    this.out.writeShort(0);
                    continue;
                }
                if (recordTypes[i] == Boolean.class) {
                    this.out.writeBoolean(false);
                    continue;
                }
                LOG.warn("Record with unsupported recordField of type " + recordFields[i].getClass());
                this.out.writeByte(0);
                continue;
            }
            if (recordFields[i] instanceof String) {
                this.out.writeInt(this.monitoringController.getIdForString((String)recordFields[i]));
                continue;
            }
            if (recordFields[i] instanceof Integer) {
                this.out.writeInt((Integer)recordFields[i]);
                continue;
            }
            if (recordFields[i] instanceof Long) {
                this.out.writeLong((Long)recordFields[i]);
                continue;
            }
            if (recordFields[i] instanceof Float) {
                this.out.writeFloat(((Float)recordFields[i]).floatValue());
                continue;
            }
            if (recordFields[i] instanceof Double) {
                this.out.writeDouble((Double)recordFields[i]);
                continue;
            }
            if (recordFields[i] instanceof Byte) {
                this.out.writeByte(((Byte)recordFields[i]).byteValue());
                continue;
            }
            if (recordFields[i] instanceof Short) {
                this.out.writeShort(((Short)recordFields[i]).shortValue());
                continue;
            }
            if (recordFields[i] instanceof Boolean) {
                this.out.writeBoolean((Boolean)recordFields[i]);
                continue;
            }
            LOG.warn("Record with unsupported recordField of type " + recordFields[i].getClass());
            this.out.writeByte(0);
        }
    }

    @Override
    protected void prepareFile(String filename) throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        this.out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));
    }

    @Override
    protected void cleanup() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException ex) {
                LOG.error("Failed to close channel.", ex);
            }
        }
    }
}

