/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.jmx;

import java.lang.management.ManagementFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.IMonitoringRecord;
import kieker.monitoring.writer.AbstractMonitoringWriter;
import kieker.monitoring.writer.jmx.KiekerJMXMonitoringLog;

public final class JMXWriter
extends AbstractMonitoringWriter {
    private static final String PREFIX = JMXWriter.class.getName() + ".";
    public static final String CONFIG_DOMAIN = PREFIX + "domain";
    public static final String CONFIG_LOGNAME = PREFIX + "logname";
    private static final Log LOG = LogFactory.getLog(JMXWriter.class);
    private KiekerJMXMonitoringLog kiekerJMXMonitoringLog;
    private ObjectName monitoringLogName;

    public JMXWriter(Configuration configuration) {
        super(configuration);
    }

    protected void init() throws Exception {
        try {
            String domain = this.configuration.getStringProperty(CONFIG_DOMAIN);
            if ("".equals(domain)) {
                domain = this.monitoringController.getJMXDomain();
            }
            this.monitoringLogName = new ObjectName(domain, "type", this.configuration.getStringProperty(CONFIG_LOGNAME));
        }
        catch (MalformedObjectNameException ex) {
            throw new IllegalArgumentException("The generated ObjectName is not correct! Check the following configuration values '" + CONFIG_DOMAIN + "=" + this.configuration.getStringProperty(CONFIG_DOMAIN) + "' and '" + CONFIG_LOGNAME + "=" + this.configuration.getStringProperty(CONFIG_LOGNAME) + "'", ex);
        }
        this.kiekerJMXMonitoringLog = new KiekerJMXMonitoringLog(this.monitoringLogName);
        try {
            ManagementFactory.getPlatformMBeanServer().registerMBean(this.kiekerJMXMonitoringLog, this.monitoringLogName);
        }
        catch (Exception ex) {
            throw new Exception("Failed to inititialize JMXWriter.", ex);
        }
    }

    public boolean newMonitoringRecord(IMonitoringRecord record) {
        return this.kiekerJMXMonitoringLog.newMonitoringRecord(record);
    }

    public void terminate() {
        try {
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.monitoringLogName);
        }
        catch (Exception ex) {
            LOG.error("Failed to terminate writer", ex);
        }
    }
}

