/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.logReplayer;

import kieker.analysis.AnalysisController;
import kieker.analysis.exception.AnalysisConfigurationException;
import kieker.analysis.plugin.AbstractPlugin;
import kieker.analysis.plugin.filter.forward.RealtimeRecordDelayFilter;
import kieker.analysis.plugin.filter.select.TimestampFilter;
import kieker.analysis.plugin.reader.AbstractReaderPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.tools.logReplayer.MonitoringRecordLoggerFilter;

public abstract class AbstractLogReplayer {
    public static final long MAX_TIMESTAMP = Long.MAX_VALUE;
    public static final long MIN_TIMESTAMP = 0L;
    private static final Log LOG = LogFactory.getLog(AbstractLogReplayer.class);
    private final long ignoreRecordsBeforeTimestamp;
    private final long ignoreRecordsAfterTimestamp;
    private final String monitoringConfigurationFile;
    private final boolean realtimeMode;
    private final boolean keepOriginalLoggingTimestamps;
    private final int numRealtimeWorkerThreads;

    public AbstractLogReplayer(String monitoringConfigurationFile, boolean realtimeMode, boolean keepOriginalLoggingTimestamps, int numRealtimeWorkerThreads, long ignoreRecordsBeforeTimestamp, long ignoreRecordsAfterTimestamp) {
        this.realtimeMode = realtimeMode;
        this.keepOriginalLoggingTimestamps = keepOriginalLoggingTimestamps;
        this.numRealtimeWorkerThreads = numRealtimeWorkerThreads;
        if (this.numRealtimeWorkerThreads <= 0) {
            LOG.warn("numRealtimeWorkerThreads == " + numRealtimeWorkerThreads);
        }
        this.ignoreRecordsBeforeTimestamp = ignoreRecordsBeforeTimestamp;
        this.ignoreRecordsAfterTimestamp = ignoreRecordsAfterTimestamp;
        this.monitoringConfigurationFile = monitoringConfigurationFile;
        if (this.monitoringConfigurationFile == null) {
            LOG.info("No path to a 'monitoring.properties' passed; default configuration will be used.");
        }
    }

    public boolean replay() {
        boolean success = true;
        try {
            AnalysisController analysisInstance = new AnalysisController();
            AbstractReaderPlugin reader = this.createReader();
            analysisInstance.registerReader(reader);
            AbstractPlugin lastFilter = reader;
            String lastOutputPortName = this.readerOutputPortName();
            Configuration timestampFilterConfiguration = new Configuration();
            boolean atLeastOneTimestampGiven = false;
            if (this.ignoreRecordsBeforeTimestamp > 0L) {
                atLeastOneTimestampGiven = true;
                timestampFilterConfiguration.setProperty("ignoreBeforeTimestamp", Long.toString(this.ignoreRecordsBeforeTimestamp));
            }
            if (this.ignoreRecordsAfterTimestamp < Long.MAX_VALUE) {
                atLeastOneTimestampGiven = true;
                timestampFilterConfiguration.setProperty("ignoreAfterTimestamp", Long.toString(this.ignoreRecordsAfterTimestamp));
            }
            if (atLeastOneTimestampGiven) {
                TimestampFilter timestampFilter = new TimestampFilter(timestampFilterConfiguration);
                analysisInstance.registerFilter(timestampFilter);
                analysisInstance.connect(lastFilter, lastOutputPortName, timestampFilter, "monitoringRecordsAny");
                lastFilter = timestampFilter;
                lastOutputPortName = "recordsWithinTimePeriod";
            }
            if (this.realtimeMode) {
                Configuration delayFilterConfiguration = new Configuration();
                delayFilterConfiguration.setProperty("numWorkers", Integer.toString(this.numRealtimeWorkerThreads));
                RealtimeRecordDelayFilter rtFilter = new RealtimeRecordDelayFilter(delayFilterConfiguration);
                analysisInstance.registerFilter(rtFilter);
                analysisInstance.connect(lastFilter, lastOutputPortName, rtFilter, "inputRecords");
                lastFilter = rtFilter;
                lastOutputPortName = "outputRecords";
            }
            Configuration recordLoggerConfig = new Configuration();
            if (this.monitoringConfigurationFile != null) {
                recordLoggerConfig.setProperty("monitoringPropertiesFilename", this.monitoringConfigurationFile);
            }
            recordLoggerConfig.setProperty("kieker.monitoring.setLoggingTimestamp", Boolean.toString(!this.keepOriginalLoggingTimestamps));
            MonitoringRecordLoggerFilter recordLogger = new MonitoringRecordLoggerFilter(recordLoggerConfig);
            analysisInstance.registerFilter(recordLogger);
            analysisInstance.connect(lastFilter, lastOutputPortName, recordLogger, "monitoringRecords");
            analysisInstance.run();
        }
        catch (IllegalStateException e) {
            LOG.error("An error occurred while replaying", e);
            success = false;
        }
        catch (AnalysisConfigurationException e) {
            LOG.error("An error occurred while replaying", e);
            success = false;
        }
        return success;
    }

    protected abstract String readerOutputPortName();

    protected abstract AbstractReaderPlugin createReader();
}

