/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.logReplayer;

import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.IMonitoringRecord;
import kieker.monitoring.core.configuration.ConfigurationFactory;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;

@Plugin(description="A filter which passes received records to the configured monitoring controller", outputPorts={@OutputPort(name="relayedEvents", description="Provides each incoming monitoring record", eventTypes={IMonitoringRecord.class})}, configuration={@Property(name="monitoringPropertiesFilename", defaultValue="")})
public class MonitoringRecordLoggerFilter
extends AbstractFilterPlugin {
    public static final String INPUT_PORT_NAME_RECORD = "monitoringRecords";
    public static final String OUTPUT_PORT_NAME_RELAYED_EVENTS = "relayedEvents";
    public static final String CONFIG_PROPERTY_NAME_MONITORING_PROPS_FN = "monitoringPropertiesFilename";
    private static final Log LOG = LogFactory.getLog(MonitoringRecordLoggerFilter.class);
    private final IMonitoringController monitoringController;
    private final Configuration configuration;

    public MonitoringRecordLoggerFilter(Configuration configuration) {
        super(configuration);
        Configuration controllerConfiguration;
        String monitoringPropertiesFn = configuration.getPathProperty(CONFIG_PROPERTY_NAME_MONITORING_PROPS_FN);
        if (monitoringPropertiesFn.length() > 0) {
            controllerConfiguration = ConfigurationFactory.createConfigurationFromFile(monitoringPropertiesFn);
        } else {
            LOG.info("No path to a 'monitoring.properties' file passed; using default configuration");
            controllerConfiguration = ConfigurationFactory.createDefaultConfiguration();
        }
        Configuration flatConfiguration = configuration.getPropertiesStartingWith("");
        this.configuration = (Configuration)flatConfiguration.clone();
        try {
            flatConfiguration.setDefaultConfiguration(controllerConfiguration);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        this.monitoringController = MonitoringController.createInstance(flatConfiguration);
    }

    public void terminate(boolean error) {
        super.terminate(error);
        this.monitoringController.terminateMonitoring();
    }

    public Configuration getCurrentConfiguration() {
        return (Configuration)this.configuration.clone();
    }

    @InputPort(name="monitoringRecords", description="Receives records to be passed to the controller", eventTypes={IMonitoringRecord.class})
    public final void inputIMonitoringRecord(IMonitoringRecord record) {
        this.monitoringController.newMonitoringRecord(record);
        super.deliver(OUTPUT_PORT_NAME_RELAYED_EVENTS, record);
    }
}

