/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis;

import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kieker.tools.traceAnalysis.TraceAnalysisTool;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public final class Constants {
    public static final String CMD_OPT_NAME_INPUTDIRS = "inputdirs";
    public static final String CMD_OPT_NAME_OUTPUTDIR = "outputdir";
    public static final String CMD_OPT_NAME_OUTPUTFNPREFIX = "output-filename-prefix";
    public static final String CMD_OPT_NAME_SELECTTRACES = "select-traces";
    public static final String CMD_OPT_NAME_SHORTLABELS = "short-labels";
    public static final String CMD_OPT_NAME_INCLUDESELFLOOPS = "include-self-loops";
    public static final String CMD_OPT_NAME_IGNOREINVALIDTRACES = "ignore-invalid-traces";
    public static final String CMD_OPT_NAME_TASK_PLOTALLOCATIONSEQDS = "plot-Deployment-Sequence-Diagrams";
    public static final String CMD_OPT_NAME_TASK_PLOTASSEMBLYSEQDS = "plot-Assembly-Sequence-Diagrams";
    public static final String CMD_OPT_NAME_TASK_PLOTALLOCATIONCOMPONENTDEPG = "plot-Deployment-Component-Dependency-Graph";
    public static final String CMD_OPT_NAME_TASK_PLOTASSEMBLYCOMPONENTDEPG = "plot-Assembly-Component-Dependency-Graph";
    public static final String CMD_OPT_NAME_TASK_PLOTCONTAINERDEPG = "plot-Container-Dependency-Graph";
    public static final String CMD_OPT_NAME_TASK_PLOTALLOCATIONOPERATIONDEPG = "plot-Deployment-Operation-Dependency-Graph";
    public static final String CMD_OPT_NAME_TASK_PLOTASSEMBLYOPERATIONDEPG = "plot-Assembly-Operation-Dependency-Graph";
    public static final String CMD_OPT_NAME_TASK_PLOTAGGREGATEDALLOCATIONCALLTREE = "plot-Aggregated-Deployment-Call-Tree";
    public static final String CMD_OPT_NAME_TASK_PLOTAGGREGATEDASSEMBLYCALLTREE = "plot-Aggregated-Assembly-Call-Tree";
    public static final String CMD_OPT_NAME_TASK_PLOTCALLTREES = "plot-Call-Trees";
    public static final String CMD_OPT_NAME_TASK_PRINTMSGTRACES = "print-Message-Traces";
    public static final String CMD_OPT_NAME_TASK_PRINTEXECTRACES = "print-Execution-Traces";
    public static final String CMD_OPT_NAME_TASK_PRINTINVALIDEXECTRACES = "print-invalid-Execution-Traces";
    public static final String CMD_OPT_NAME_TASK_ALLOCATIONEQUIVCLASSREPORT = "print-Deployment-Equivalence-Classes";
    public static final String CMD_OPT_NAME_TASK_ASSEMBLYEQUIVCLASSREPORT = "print-Assembly-Equivalence-Classes";
    public static final String CMD_OPT_NAME_MAXTRACEDURATION = "max-trace-duration";
    public static final String CMD_OPT_NAME_IGNOREEXECUTIONSBEFOREDATE = "ignore-executions-before-date";
    public static final String CMD_OPT_NAME_IGNOREEXECUTIONSAFTERDATE = "ignore-executions-after-date";
    public static final String ALLOCATION_SEQUENCE_DIAGRAM_FN_PREFIX = "deploymentSequenceDiagram";
    public static final String ASSEMBLY_SEQUENCE_DIAGRAM_FN_PREFIX = "assemblySequenceDiagram";
    public static final String ALLOCATION_COMPONENT_DEPENDENCY_GRAPH_FN_PREFIX = "deploymentComponentDependencyGraph";
    public static final String ASSEMBLY_COMPONENT_DEPENDENCY_GRAPH_FN_PREFIX = "assemblyComponentDependencyGraph";
    public static final String CONTAINER_DEPENDENCY_GRAPH_FN_PREFIX = "containerDependencyGraph";
    public static final String ALLOCATION_OPERATION_DEPENDENCY_GRAPH_FN_PREFIX = "deploymentOperationDependencyGraph";
    public static final String ASSEMBLY_OPERATION_DEPENDENCY_GRAPH_FN_PREFIX = "assemblyOperationDependencyGraph";
    public static final String AGGREGATED_ALLOCATION_CALL_TREE_FN_PREFIX = "aggregatedDeploymentCallTree";
    public static final String AGGREGATED_ASSEMBLY_CALL_TREE_FN_PREFIX = "aggregatedAssemblyCallTree";
    public static final String DOT_FILE_SUFFIX = ".dot";
    public static final String CALL_TREE_FN_PREFIX = "callTree";
    public static final String MESSAGE_TRACES_FN_PREFIX = "messageTraces";
    public static final String EXECUTION_TRACES_FN_PREFIX = "executionTraces";
    public static final String INVALID_TRACES_FN_PREFIX = "invalidTraceArtifacts";
    public static final String TRACE_ALLOCATION_EQUIV_CLASSES_FN_PREFIX = "traceDeploymentEquivClasses";
    public static final String TRACE_ASSEMBLY_EQUIV_CLASSES_FN_PREFIX = "traceAssemblyEquivClasses";
    public static final String DATE_FORMAT_PATTERN = "yyyyMMdd'-'HHmmss";
    public static final String EXEC_TRACE_RECONSTR_COMPONENT_NAME = "Execution record transformation";
    public static final String TRACERECONSTR_COMPONENT_NAME = "Trace reconstruction (execution records -> execution traces)";
    public static final String TRACEALLOCATIONEQUIVCLASS_COMPONENT_NAME = "Trace equivalence class filter (deployment mode)";
    public static final String TRACEASSEMBLYEQUIVCLASS_COMPONENT_NAME = "Trace equivalence class filter (assembly mode)";
    public static final String EVENTRECORDTRACERECONSTR_COMPONENT_NAME = "Trace reconstruction (trace event records -> event record traces)";
    public static final String EXECTRACESFROMEVENTTRACES_COMPONENT_NAME = "Trace reconstruction (event record traces -> execution traces)";
    public static final String PRINTMSGTRACE_COMPONENT_NAME = "Print message traces";
    public static final String PRINTEXECTRACE_COMPONENT_NAME = "Print execution traces";
    public static final String PRINTINVALIDEXECTRACE_COMPONENT_NAME = "Print invalid execution traces";
    public static final String PLOTALLOCATIONCOMPONENTDEPGRAPH_COMPONENT_NAME = "Component dependency graph (deployment level)";
    public static final String PLOTASSEMBLYCOMPONENTDEPGRAPH_COMPONENT_NAME = "Component dependency graph (assembly level)";
    public static final String PLOTCONTAINERDEPGRAPH_COMPONENT_NAME = "Container dependency graph";
    public static final String PLOTALLOCATIONOPERATIONDEPGRAPH_COMPONENT_NAME = "Operation dependency graph (deployment level)";
    public static final String PLOTASSEMBLYOPERATIONDEPGRAPH_COMPONENT_NAME = "Operation dependency graph (assembly level)";
    public static final String PLOTALLOCATIONSEQDIAGR_COMPONENT_NAME = "Sequence diagrams (deployment level)";
    public static final String PLOTASSEMBLYSEQDIAGR_COMPONENT_NAME = "Sequence diagrams (assembly level)";
    public static final String PLOTAGGREGATEDALLOCATIONCALLTREE_COMPONENT_NAME = "Aggregated call tree (deployment level)";
    public static final String PLOTAGGREGATEDASSEMBLYCALLTREE_COMPONENT_NAME = "Aggregated call tree (assembly level)";
    public static final String PLOTCALLTREE_COMPONENT_NAME = "Trace call trees";
    public static final HelpFormatter CMD_HELP_FORMATTER = new HelpFormatter();
    public static final Options CMDL_OPTIONS = new Options();
    public static final List<Option> SORTED_OPTION_LIST = new CopyOnWriteArrayList<Option>();
    public static final String DECORATORS_OPTION_NAME = "node decorations";
    public static final char DECORATOR_SEPARATOR = ',';
    public static final String RESPONSE_TIME_DECORATOR_FLAG = "responseTimes";
    public static final String CMD_OPT_NAME_TRACE_COLORING = "traceColoring";
    public static final String COLORING_FILE_OPTION_NAME = "color map file";
    public static final String CMD_OPT_NAME_ADD_DESCRIPTIONS = "addDescriptions";
    public static final String DESCRIPTIONS_FILE_OPTION_NAME = "descriptions file";

    private Constants() {
    }

    public static String stringArrToStringList(String[] strs) {
        StringBuilder strB = new StringBuilder();
        boolean first = true;
        for (String s : strs) {
            if (!first) {
                strB.append(", ");
            } else {
                first = false;
            }
            strB.append(s);
        }
        return strB.toString();
    }

    static {
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_INPUTDIRS);
        OptionBuilder.withArgName((String)"dir1 ... dirN");
        OptionBuilder.hasArgs();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Log directories to read data from");
        OptionBuilder.withValueSeparator((char)'=');
        SORTED_OPTION_LIST.add(OptionBuilder.create((String)"i"));
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_OUTPUTDIR);
        OptionBuilder.withArgName((String)"dir");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Directory for the generated file(s)");
        OptionBuilder.withValueSeparator((char)'=');
        SORTED_OPTION_LIST.add(OptionBuilder.create((String)"o"));
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_OUTPUTFNPREFIX);
        OptionBuilder.withArgName((String)"prefix");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Prefix for output filenames\n");
        OptionBuilder.withValueSeparator((char)'=');
        SORTED_OPTION_LIST.add(OptionBuilder.create((String)"p"));
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_TASK_PLOTALLOCATIONSEQDS);
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Generate and store deployment-level sequence diagrams (.pic files)");
        SORTED_OPTION_LIST.add(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_TASK_PLOTASSEMBLYSEQDS);
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Generate and store assembly-level sequence diagrams (.pic files)");
        SORTED_OPTION_LIST.add(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_TASK_PLOTALLOCATIONCOMPONENTDEPG);
        OptionBuilder.withArgName((String)DECORATORS_OPTION_NAME);
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.withDescription((String)"Generate and store a deployment-level component dependency graph (.dot file)");
        SORTED_OPTION_LIST.add(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_TASK_PLOTASSEMBLYCOMPONENTDEPG);
        OptionBuilder.withArgName((String)DECORATORS_OPTION_NAME);
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.withDescription((String)"Generate and store an assembly-level component dependency graph (.dot file)");
        SORTED_OPTION_LIST.add(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_TASK_PLOTCONTAINERDEPG);
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Generate and store a container dependency graph (.dot file)");
        SORTED_OPTION_LIST.add(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_TASK_PLOTALLOCATIONOPERATIONDEPG);
        OptionBuilder.withArgName((String)DECORATORS_OPTION_NAME);
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.withDescription((String)"Generate and store a deployment-level operation dependency graph (.dot file)");
        SORTED_OPTION_LIST.add(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_TASK_PLOTASSEMBLYOPERATIONDEPG);
        OptionBuilder.withArgName((String)DECORATORS_OPTION_NAME);
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.withDescription((String)"Generate and store an assembly-level operation dependency graph (.dot file)");
        SORTED_OPTION_LIST.add(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_TASK_PLOTAGGREGATEDALLOCATIONCALLTREE);
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Generate and store an aggregated deployment-level call tree (.dot files)");
        SORTED_OPTION_LIST.add(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_TASK_PLOTAGGREGATEDASSEMBLYCALLTREE);
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Generate and store an aggregated assembly-level call tree (.dot files)");
        SORTED_OPTION_LIST.add(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_TASK_PLOTCALLTREES);
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Generate and store call trees for the selected traces (.dot files)");
        SORTED_OPTION_LIST.add(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_TASK_PRINTMSGTRACES);
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Save message trace representations of valid traces (.txt files)");
        SORTED_OPTION_LIST.add(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_TASK_PRINTEXECTRACES);
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Save execution trace representations of valid traces (.txt files)");
        SORTED_OPTION_LIST.add(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_TASK_PRINTINVALIDEXECTRACES);
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Save a execution trace representations of invalid trace artifacts (.txt files)");
        SORTED_OPTION_LIST.add(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_TASK_ALLOCATIONEQUIVCLASSREPORT);
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Output an overview about the deployment-level trace equivalence classes");
        SORTED_OPTION_LIST.add(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_TASK_ASSEMBLYEQUIVCLASSREPORT);
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Output an overview about the assembly-level trace equivalence classes");
        SORTED_OPTION_LIST.add(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_SELECTTRACES);
        OptionBuilder.withArgName((String)"id0 ... idn");
        OptionBuilder.hasArgs();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Consider only the traces identified by the list of trace IDs. Defaults to all traces.");
        SORTED_OPTION_LIST.add(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_IGNOREINVALIDTRACES);
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"If selected, the execution aborts on the occurence of an invalid trace.");
        SORTED_OPTION_LIST.add(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_MAXTRACEDURATION);
        OptionBuilder.withArgName((String)"duration in ms");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Threshold (in milliseconds) after which an incomplete trace becomes invalid. Defaults to 600000 (10 minutes).");
        SORTED_OPTION_LIST.add(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_IGNOREEXECUTIONSBEFOREDATE);
        OptionBuilder.withArgName((String)TraceAnalysisTool.DATE_FORMAT_PATTERN_CMD_USAGE_HELP);
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Executions starting before this date (UTC timezone) are ignored.");
        SORTED_OPTION_LIST.add(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_IGNOREEXECUTIONSAFTERDATE);
        OptionBuilder.withArgName((String)TraceAnalysisTool.DATE_FORMAT_PATTERN_CMD_USAGE_HELP);
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Executions ending after this date (UTC timezone) are ignored.");
        SORTED_OPTION_LIST.add(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_SHORTLABELS);
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"If selected, abbreviated labels (e.g., package names) are used in the visualizations.");
        SORTED_OPTION_LIST.add(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_INCLUDESELFLOOPS);
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"If selected, self-loops are included in the visualizations.");
        SORTED_OPTION_LIST.add(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_TRACE_COLORING);
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Color traces according to the given color map.");
        OptionBuilder.withArgName((String)COLORING_FILE_OPTION_NAME);
        SORTED_OPTION_LIST.add(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)CMD_OPT_NAME_ADD_DESCRIPTIONS);
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Adds descriptions to elements according to the given file.");
        OptionBuilder.withArgName((String)DESCRIPTIONS_FILE_OPTION_NAME);
        SORTED_OPTION_LIST.add(OptionBuilder.create());
        for (Option o : SORTED_OPTION_LIST) {
            CMDL_OPTIONS.addOption(o);
        }
        CMD_HELP_FORMATTER.setOptionComparator((Comparator)new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                int posO2;
                if (o1 == o2) {
                    return 0;
                }
                int posO1 = SORTED_OPTION_LIST.indexOf(o1);
                if (posO1 < (posO2 = SORTED_OPTION_LIST.indexOf(o2))) {
                    return -1;
                }
                if (posO1 > posO2) {
                    return 1;
                }
                return 0;
            }
        });
    }
}

