/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter.visualization;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kieker.analysis.exception.AnalysisConfigurationException;
import kieker.analysis.plugin.AbstractPlugin;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.tools.traceAnalysis.filter.IGraphOutputtingFilter;
import kieker.tools.traceAnalysis.filter.IGraphProducingFilter;
import kieker.tools.traceAnalysis.filter.visualization.graph.AbstractEdge;
import kieker.tools.traceAnalysis.filter.visualization.graph.AbstractGraph;
import kieker.tools.traceAnalysis.filter.visualization.graph.AbstractVertex;
import kieker.tools.traceAnalysis.filter.visualization.graph.IOriginRetentionPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Plugin
public abstract class AbstractGraphFilter<G extends AbstractGraph<V, E, O>, V extends AbstractVertex<V, E, O>, E extends AbstractEdge<V, E, O>, O>
extends AbstractFilterPlugin
implements IGraphOutputtingFilter<G> {
    public static final String INPUT_PORT_NAME_GRAPH = "graphs";
    private static final Log LOG = LogFactory.getLog(AbstractGraphFilter.class);
    private final Configuration configuration;
    private final List<IGraphProducingFilter<?>> producers = new ArrayList();

    public AbstractGraphFilter(Configuration configuration) {
        super(configuration);
        this.configuration = configuration;
    }

    @Override
    protected void notifyNewIncomingConnection(String inputPortName, AbstractPlugin connectedPlugin, String outputPortName) throws AnalysisConfigurationException {
        Set<AbstractPlugin> predecessors = connectedPlugin.getIncomingPlugins(true);
        predecessors.add(connectedPlugin);
        for (AbstractPlugin plugin : predecessors) {
            if (!(plugin instanceof IGraphProducingFilter)) continue;
            IGraphProducingFilter graphProducer = (IGraphProducingFilter)((Object)plugin);
            this.producers.add(graphProducer);
        }
    }

    @Override
    public boolean init() {
        if (!super.init()) {
            return false;
        }
        try {
            for (IGraphProducingFilter<?> producer : this.producers) {
                producer.requestOriginRetentionPolicy(this.getDesiredOriginRetentionPolicy());
            }
        }
        catch (AnalysisConfigurationException e) {
            LOG.error(e.getMessage(), e);
            return false;
        }
        return true;
    }

    protected abstract IOriginRetentionPolicy getDesiredOriginRetentionPolicy() throws AnalysisConfigurationException;

    @Override
    public Configuration getCurrentConfiguration() {
        return this.configuration;
    }

    @InputPort(name="graphs", description="Graphs to process", eventTypes={AbstractGraph.class})
    public void processGraph(G graph) {
        G processedGraph = this.performConcreteGraphProcessing(graph);
        this.deliver(this.getGraphOutputPortName(), processedGraph);
    }

    @Override
    public String getGraphOutputPortName() {
        return INPUT_PORT_NAME_GRAPH;
    }

    public String getGraphInputPortName() {
        return INPUT_PORT_NAME_GRAPH;
    }

    protected abstract G performConcreteGraphProcessing(G var1);
}

