/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter.visualization.dependencyGraph;

import kieker.tools.traceAnalysis.filter.visualization.AbstractGraphFormatter;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.AbstractComponentDependencyGraphFormatter;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.AbstractDependencyGraphFormatter;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.AbstractDependencyGraphFormatterVisitor;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.ComponentAssemblyDependencyGraph;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.DependencyGraphNode;
import kieker.tools.traceAnalysis.filter.visualization.util.dot.DotFactory;
import kieker.tools.traceAnalysis.systemModel.AssemblyComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentAssemblyDependencyGraphFormatter
extends AbstractComponentDependencyGraphFormatter<ComponentAssemblyDependencyGraph> {
    private static final String DEFAULT_FILE_NAME = "assemblyComponentDependencyGraph.dot";

    @Override
    protected String formatDependencyGraph(ComponentAssemblyDependencyGraph graph, boolean includeWeights, boolean useShortLabels, boolean plotLoops) {
        StringBuilder builder = new StringBuilder();
        this.appendGraphHeader(builder);
        graph.traverseWithVerticesFirst(new FormatterVisitor(builder, includeWeights, plotLoops, useShortLabels));
        this.appendGraphFooter(builder);
        return builder.toString();
    }

    @Override
    public String getDefaultFileName() {
        return DEFAULT_FILE_NAME;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FormatterVisitor
    extends AbstractDependencyGraphFormatterVisitor<AssemblyComponent> {
        public FormatterVisitor(StringBuilder builder, boolean includeWeights, boolean plotLoops, boolean useShortLabels) {
            super(builder, includeWeights, plotLoops, useShortLabels);
        }

        private String createNodeLabel(DependencyGraphNode<AssemblyComponent> vertex, AssemblyComponent component) {
            StringBuilder builder = new StringBuilder();
            builder.append("<<assembly component>>").append("\\n");
            builder.append(component.getName()).append(':');
            if (this.useShortLabels) {
                builder.append("..").append(component.getType().getTypeName());
            } else {
                builder.append(component.getType().getFullQualifiedName());
            }
            ComponentAssemblyDependencyGraphFormatter.formatDecorations(builder, vertex);
            return builder.toString();
        }

        @Override
        public void visitVertex(DependencyGraphNode<AssemblyComponent> vertex) {
            AssemblyComponent component = vertex.getEntity();
            if (component.isRootComponent()) {
                this.builder.append((CharSequence)DotFactory.createNode("", AbstractDependencyGraphFormatter.createNodeId(vertex), component.getName(), "none", null, null, null, null, 0.0, null, null, null));
            } else {
                this.builder.append((CharSequence)DotFactory.createNode("", AbstractDependencyGraphFormatter.createNodeId(vertex), this.createNodeLabel(vertex, component), "box", "filled", AbstractGraphFormatter.getDotRepresentation(vertex.getColor()), AbstractDependencyGraphFormatter.getNodeFillColor(vertex), null, 0.0, null, null, vertex.getDescription()));
            }
            this.builder.append("\n");
        }
    }
}

