/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter.visualization.dependencyGraph;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kieker.tools.traceAnalysis.filter.visualization.AbstractGraphFormatter;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.AbstractDependencyGraphFormatter;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.AbstractDependencyGraphFormatterVisitor;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.AbstractOperationDependencyGraphFormatter;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.DependencyGraphNode;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.OperationAssemblyDependencyGraph;
import kieker.tools.traceAnalysis.filter.visualization.util.dot.DotFactory;
import kieker.tools.traceAnalysis.systemModel.AssemblyComponent;
import kieker.tools.traceAnalysis.systemModel.Operation;
import kieker.tools.traceAnalysis.systemModel.util.AssemblyComponentOperationPair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationAssemblyDependencyGraphFormatter
extends AbstractOperationDependencyGraphFormatter<OperationAssemblyDependencyGraph> {
    private static final String DEFAULT_FILE_NAME = "assemblyOperationDependencyGraph.dot";

    private ConcurrentMap<AssemblyComponent, List<DependencyGraphNode<AssemblyComponentOperationPair>>> groupNodesByComponent(OperationAssemblyDependencyGraph graph) {
        ConcurrentHashMap<AssemblyComponent, List<DependencyGraphNode<AssemblyComponentOperationPair>>> grouping = new ConcurrentHashMap<AssemblyComponent, List<DependencyGraphNode<AssemblyComponentOperationPair>>>();
        for (DependencyGraphNode vertex : graph.getVertices()) {
            AssemblyComponentOperationPair pair = (AssemblyComponentOperationPair)vertex.getEntity();
            AssemblyComponent assemblyComponent = pair.getAssemblyComponent();
            ArrayList nodes = (ArrayList)grouping.get(assemblyComponent);
            if (nodes == null) {
                nodes = new ArrayList();
                grouping.put(assemblyComponent, nodes);
            }
            nodes.add(vertex);
        }
        return grouping;
    }

    private static String createComponentNodeLabel(AssemblyComponent component, boolean useShortLabels) {
        StringBuilder builder = new StringBuilder();
        builder.append("<<assembly component>>").append("\\n");
        builder.append(component.getName()).append(':');
        if (useShortLabels) {
            builder.append("..");
        } else {
            builder.append(component.getType().getPackageName()).append('.');
        }
        builder.append(component.getType().getTypeName());
        return builder.toString();
    }

    private void createGraph(StringBuilder builder, Map<AssemblyComponent, List<DependencyGraphNode<AssemblyComponentOperationPair>>> grouping, boolean useShortLabels) {
        for (Map.Entry<AssemblyComponent, List<DependencyGraphNode<AssemblyComponentOperationPair>>> entry : grouping.entrySet()) {
            AssemblyComponent assemblyComponent = entry.getKey();
            if (assemblyComponent.isRootComponent()) {
                builder.append((CharSequence)DotFactory.createNode("", AbstractDependencyGraphFormatter.createNodeId(assemblyComponent.getId()), assemblyComponent.getName(), "none", null, null, null, null, 0.0, null, null, null));
                continue;
            }
            builder.append((CharSequence)DotFactory.createCluster("", AbstractDependencyGraphFormatter.createAssemblyComponentId(assemblyComponent), OperationAssemblyDependencyGraphFormatter.createComponentNodeLabel(assemblyComponent, useShortLabels), "box", "filled", null, "white", null, 0.0, null));
            for (DependencyGraphNode<AssemblyComponentOperationPair> node : entry.getValue()) {
                Operation operation = node.getEntity().getOperation();
                builder.append((CharSequence)DotFactory.createNode("", AbstractDependencyGraphFormatter.createNodeId(node), this.createOperationNodeLabel(operation, node), "oval", "filled", AbstractGraphFormatter.getDotRepresentation(node.getColor()), AbstractDependencyGraphFormatter.getNodeFillColor(node), null, 0.0, null, null, node.getDescription()));
            }
            builder.append("}\n");
        }
    }

    @Override
    protected String formatDependencyGraph(OperationAssemblyDependencyGraph graph, boolean includeWeights, boolean useShortLabels, boolean plotLoops) {
        StringBuilder builder = new StringBuilder();
        this.appendGraphHeader(builder);
        ConcurrentMap<AssemblyComponent, List<DependencyGraphNode<AssemblyComponentOperationPair>>> grouping = this.groupNodesByComponent(graph);
        this.createGraph(builder, grouping, useShortLabels);
        graph.traverseWithVerticesFirst(new EdgeVisitor(builder, includeWeights, plotLoops, useShortLabels));
        this.appendGraphFooter(builder);
        return builder.toString();
    }

    @Override
    public String getDefaultFileName() {
        return DEFAULT_FILE_NAME;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EdgeVisitor
    extends AbstractDependencyGraphFormatterVisitor<AssemblyComponentOperationPair> {
        public EdgeVisitor(StringBuilder builder, boolean includeWeights, boolean plotLoops, boolean useShortLabels) {
            super(builder, includeWeights, plotLoops, useShortLabels);
        }

        @Override
        public void visitVertex(DependencyGraphNode<AssemblyComponentOperationPair> vertex) {
        }
    }
}

