/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter.visualization.dependencyGraph;

import kieker.tools.traceAnalysis.filter.visualization.graph.AbstractVertexDecoration;
import kieker.tools.traceAnalysis.systemModel.Execution;

public class ResponseTimeDecoration
extends AbstractVertexDecoration {
    private static final String OUTPUT_TEMPLATE = "min: %dms, avg: %.2fms, max: %dms";
    private long responseTimeSum;
    private int executionCount;
    private int minimalResponseTime = Integer.MAX_VALUE;
    private int maximalResponseTime;

    public void registerExecution(Execution execution) {
        int responseTime = (int)(execution.getTout() / 1000000L - execution.getTin() / 1000000L);
        this.responseTimeSum += (long)responseTime;
        ++this.executionCount;
        if (responseTime < this.minimalResponseTime) {
            this.minimalResponseTime = responseTime;
        }
        if (responseTime > this.maximalResponseTime) {
            this.maximalResponseTime = responseTime;
        }
    }

    public int getMinimalResponseTime() {
        return this.minimalResponseTime;
    }

    public int getMaximalResponseTime() {
        return this.maximalResponseTime;
    }

    public double getAverageResponseTime() {
        return this.executionCount == 0 ? 0.0 : (double)this.responseTimeSum / (double)this.executionCount;
    }

    public String createFormattedOutput() {
        return String.format(OUTPUT_TEMPLATE, this.getMinimalResponseTime(), this.getAverageResponseTime(), this.getMaximalResponseTime());
    }
}

