/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter.visualization.descriptions;

import java.util.Map;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.RepositoryPort;
import kieker.common.configuration.Configuration;
import kieker.tools.traceAnalysis.filter.visualization.AbstractGraphFilter;
import kieker.tools.traceAnalysis.filter.visualization.graph.AbstractEdge;
import kieker.tools.traceAnalysis.filter.visualization.graph.AbstractGraph;
import kieker.tools.traceAnalysis.filter.visualization.graph.AbstractGraphElement;
import kieker.tools.traceAnalysis.filter.visualization.graph.AbstractPayloadedVertex;
import kieker.tools.traceAnalysis.filter.visualization.graph.IOriginRetentionPolicy;
import kieker.tools.traceAnalysis.filter.visualization.graph.NoOriginRetentionPolicy;
import kieker.tools.traceAnalysis.repository.DescriptionRepository;
import kieker.tools.traceAnalysis.systemModel.ISystemModelElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Plugin(name="", description="This filter attaches decorations to graph entities", repositoryPorts={@RepositoryPort(name="descriptionRepository", repositoryType=DescriptionRepository.class)}, outputPorts={@OutputPort(name="graphs", eventTypes={AbstractGraph.class})})
public class DescriptionDecoratorFilter<V extends AbstractPayloadedVertex<V, E, O, ISystemModelElement>, E extends AbstractEdge<V, E, O>, O>
extends AbstractGraphFilter<AbstractGraph<V, E, O>, V, E, O>
implements AbstractGraph.IGraphVisitor<V, E> {
    public static final String DESCRIPTION_REPOSITORY_PORT_NAME = "descriptionRepository";
    private Map<String, String> decorationsMap;

    public DescriptionDecoratorFilter(Configuration configuration) {
        super(configuration);
    }

    @Override
    public void visitVertex(V vertex) {
        ISystemModelElement element = (ISystemModelElement)((AbstractPayloadedVertex)vertex).getPayload();
        if (element == null) {
            return;
        }
        String decoration = this.decorationsMap.get(element.getIdentifier());
        ((AbstractGraphElement)vertex).setDescription(decoration);
    }

    @Override
    public void visitEdge(E edge) {
    }

    private void initialize() {
        DescriptionRepository repository = (DescriptionRepository)this.getRepository(DESCRIPTION_REPOSITORY_PORT_NAME);
        this.decorationsMap = repository.getDescriptionMap();
    }

    @Override
    protected AbstractGraph<V, E, O> performConcreteGraphProcessing(AbstractGraph<V, E, O> graph) {
        this.initialize();
        graph.traverse(this);
        return graph;
    }

    @Override
    protected IOriginRetentionPolicy getDesiredOriginRetentionPolicy() {
        return NoOriginRetentionPolicy.createInstance();
    }
}

