/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter.visualization.traceColoring;

import java.util.HashSet;
import java.util.Map;
import kieker.analysis.exception.AnalysisConfigurationException;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.RepositoryPort;
import kieker.common.configuration.Configuration;
import kieker.tools.traceAnalysis.filter.visualization.AbstractGraphFilter;
import kieker.tools.traceAnalysis.filter.visualization.graph.AbstractEdge;
import kieker.tools.traceAnalysis.filter.visualization.graph.AbstractGraph;
import kieker.tools.traceAnalysis.filter.visualization.graph.AbstractGraphElement;
import kieker.tools.traceAnalysis.filter.visualization.graph.AbstractVertex;
import kieker.tools.traceAnalysis.filter.visualization.graph.Color;
import kieker.tools.traceAnalysis.filter.visualization.graph.IOriginRetentionPolicy;
import kieker.tools.traceAnalysis.filter.visualization.graph.SpecificOriginRetentionPolicy;
import kieker.tools.traceAnalysis.repository.TraceColorRepository;
import kieker.tools.traceAnalysis.systemModel.TraceInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Plugin(name="Trace coloring filter", description="Colors graph elements that can uniquely associated to a trace according to the color repository", repositoryPorts={@RepositoryPort(name="colorRepository", repositoryType=TraceColorRepository.class)}, outputPorts={@OutputPort(name="graphs", eventTypes={AbstractGraph.class})})
public class TraceColoringFilter<V extends AbstractVertex<V, E, TraceInformation>, E extends AbstractEdge<V, E, TraceInformation>>
extends AbstractGraphFilter<AbstractGraph<V, E, TraceInformation>, V, E, TraceInformation>
implements AbstractGraph.IGraphVisitor<V, E> {
    public static final String COLOR_REPOSITORY_PORT_NAME = "colorRepository";
    private Map<Long, Color> colorMap;
    private Color defaultColor;
    private Color collisionColor;

    public TraceColoringFilter(Configuration configuration) {
        super(configuration);
    }

    private void initialize() {
        TraceColorRepository colorRepository = (TraceColorRepository)super.getRepository(COLOR_REPOSITORY_PORT_NAME);
        this.colorMap = colorRepository.getColorMap();
        this.defaultColor = colorRepository.getDefaultColor();
        this.collisionColor = colorRepository.getCollisionColor();
    }

    private void handleGraphElement(AbstractGraphElement<TraceInformation> element) {
        TraceInformation relevantTraceInformation = null;
        int relevantOrigins = 0;
        for (TraceInformation traceInformation : element.getOrigins()) {
            long traceId = traceInformation.getTraceId();
            if (!this.colorMap.containsKey(traceId)) continue;
            relevantTraceInformation = traceInformation;
            ++relevantOrigins;
        }
        if (relevantOrigins == 0) {
            element.setColor(this.defaultColor);
        } else if (relevantOrigins > 1) {
            element.setColor(this.collisionColor);
        } else {
            long traceId = relevantTraceInformation.getTraceId();
            Color color = this.colorMap.get(traceId);
            element.setColor(color);
        }
    }

    @Override
    public void visitVertex(V vertex) {
        this.handleGraphElement((AbstractGraphElement<TraceInformation>)vertex);
    }

    @Override
    public void visitEdge(E edge) {
        this.handleGraphElement((AbstractGraphElement<TraceInformation>)edge);
    }

    @Override
    protected AbstractGraph<V, E, TraceInformation> performConcreteGraphProcessing(AbstractGraph<V, E, TraceInformation> graph) {
        this.initialize();
        graph.traverse(this);
        return graph;
    }

    @Override
    protected IOriginRetentionPolicy getDesiredOriginRetentionPolicy() throws AnalysisConfigurationException {
        TraceColorRepository colorRepository = (TraceColorRepository)super.getRepository(COLOR_REPOSITORY_PORT_NAME);
        HashSet<TraceInformation> desiredTraces = new HashSet<TraceInformation>();
        for (Long traceId : colorRepository.getColorMap().keySet()) {
            desiredTraces.add(new TraceInformation(traceId, null));
        }
        return SpecificOriginRetentionPolicy.createInstance(desiredTraces);
    }
}

