/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.systemModel.repository;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import kieker.tools.traceAnalysis.systemModel.AssemblyComponent;
import kieker.tools.traceAnalysis.systemModel.ComponentType;
import kieker.tools.traceAnalysis.systemModel.RootAssemblyComponent;
import kieker.tools.traceAnalysis.systemModel.repository.AbstractSystemSubRepository;
import kieker.tools.traceAnalysis.systemModel.repository.SystemModelRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssemblyRepository
extends AbstractSystemSubRepository {
    public static final AssemblyComponent ROOT_ASSEMBLY_COMPONENT = new RootAssemblyComponent();
    private final Map<String, AssemblyComponent> assemblyComponentInstancesByName = new Hashtable<String, AssemblyComponent>();
    private final Map<Integer, AssemblyComponent> assemblyComponentInstancesById = new Hashtable<Integer, AssemblyComponent>();

    public AssemblyRepository(SystemModelRepository systemFactory) {
        super(systemFactory);
    }

    public final AssemblyComponent lookupAssemblyComponentById(int containerId) {
        return this.assemblyComponentInstancesById.get(containerId);
    }

    public final AssemblyComponent lookupAssemblyComponentInstanceByNamedIdentifier(String namedIdentifier) {
        return this.assemblyComponentInstancesByName.get(namedIdentifier);
    }

    public final AssemblyComponent createAndRegisterAssemblyComponentInstance(String namedIdentifier, ComponentType componentType) {
        if (this.assemblyComponentInstancesByName.containsKey(namedIdentifier)) {
            throw new IllegalArgumentException("Element with name " + namedIdentifier + "exists already");
        }
        int id = this.getAndIncrementNextId();
        AssemblyComponent newInst = new AssemblyComponent(id, "@" + id, componentType);
        this.assemblyComponentInstancesById.put(id, newInst);
        this.assemblyComponentInstancesByName.put(namedIdentifier, newInst);
        return newInst;
    }

    public final Collection<AssemblyComponent> getAssemblyComponentInstances() {
        return this.assemblyComponentInstancesById.values();
    }
}

