/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.filter.forward;

import java.util.concurrent.atomic.AtomicLong;
import kieker.analysis.display.PlainText;
import kieker.analysis.display.annotation.Display;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;

@Plugin(description="A filter counting the elements flowing through this filter", outputPorts={@OutputPort(name="relayedEvents", eventTypes={Object.class}, description="Provides each incoming object"), @OutputPort(name="currentEventCount", eventTypes={Long.class}, description="Provides the current object count")})
public final class CountingFilter
extends AbstractFilterPlugin {
    public static final String INPUT_PORT_NAME_EVENTS = "inputEvents";
    public static final String OUTPUT_PORT_NAME_RELAYED_EVENTS = "relayedEvents";
    public static final String OUTPUT_PORT_NAME_COUNT = "currentEventCount";
    private final AtomicLong counter = new AtomicLong();

    public CountingFilter(Configuration configuration) {
        super(configuration);
    }

    public final Configuration getCurrentConfiguration() {
        return new Configuration();
    }

    public final long getMessageCount() {
        return this.counter.get();
    }

    @InputPort(name="inputEvents", eventTypes={Object.class}, description="Receives incoming objects to be counted and forwarded")
    public final void inputEvent(Object event) {
        Long count = this.counter.incrementAndGet();
        super.deliver(OUTPUT_PORT_NAME_RELAYED_EVENTS, event);
        super.deliver(OUTPUT_PORT_NAME_COUNT, count);
    }

    @Display(name="Counter Display")
    public final void countDisplay(PlainText plainText) {
        plainText.setText(Long.toString(this.counter.get()));
    }
}

