/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.filter.forward;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;

@Plugin(description="A filter to print the object to a configured stream", outputPorts={@OutputPort(name="relayedEvents", description="Provides each incoming object", eventTypes={Object.class})}, configuration={@Property(name="stream", defaultValue="STDOUT", description="The name of the stream used to print the incoming data (valid values are STDOUT, STDERR, and STDLOG)."), @Property(name="characterEncoding", defaultValue="UTF-8", description="The used encoding for the selected stream.")})
public final class TeeFilter
extends AbstractFilterPlugin {
    public static final String INPUT_PORT_NAME_EVENTS = "receivedEvents";
    public static final String OUTPUT_PORT_NAME_RELAYED_EVENTS = "relayedEvents";
    public static final String CONFIG_PROPERTY_NAME_STREAM = "stream";
    public static final String CONFIG_PROPERTY_NAME_ENCODING = "characterEncoding";
    public static final String CONFIG_PROPERTY_VALUE_STREAM_STDOUT = "STDOUT";
    public static final String CONFIG_PROPERTY_VALUE_STREAM_STDERR = "STDERR";
    public static final String CONFIG_PROPERTY_VALUE_STREAM_STDLOG = "STDLOG";
    public static final String CONFIG_PROPERTY_VALUE_DEFAULT_ENCODING = "UTF-8";
    private static final Log LOG = LogFactory.getLog(TeeFilter.class);
    private final PrintStream printStream;
    private final String printStreamName;
    private final String encoding;

    public TeeFilter(Configuration configuration) {
        super(configuration);
        String printStreamNameConfig = this.configuration.getStringProperty(CONFIG_PROPERTY_NAME_STREAM);
        this.encoding = this.configuration.getStringProperty(CONFIG_PROPERTY_NAME_ENCODING);
        if (CONFIG_PROPERTY_VALUE_STREAM_STDLOG.equals(printStreamNameConfig)) {
            this.printStream = null;
            this.printStreamName = null;
        } else if (CONFIG_PROPERTY_VALUE_STREAM_STDOUT.equals(printStreamNameConfig)) {
            this.printStream = System.out;
            this.printStreamName = null;
        } else if (CONFIG_PROPERTY_VALUE_STREAM_STDERR.equals(printStreamNameConfig)) {
            this.printStream = System.err;
            this.printStreamName = null;
        } else {
            PrintStream tmpPrintStream;
            try {
                tmpPrintStream = new PrintStream((OutputStream)new FileOutputStream(printStreamNameConfig), false, this.encoding);
            }
            catch (UnsupportedEncodingException ex) {
                LOG.error("Failed to initialize " + printStreamNameConfig, ex);
                tmpPrintStream = null;
            }
            catch (FileNotFoundException ex) {
                LOG.error("Failed to initialize " + printStreamNameConfig, ex);
                tmpPrintStream = null;
            }
            this.printStream = tmpPrintStream;
            this.printStreamName = printStreamNameConfig;
        }
    }

    public final void terminate(boolean error) {
        if (this.printStream != null && this.printStream != System.out && this.printStream != System.err) {
            this.printStream.close();
        }
    }

    public final Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_ENCODING, this.encoding);
        if (this.printStream == null) {
            configuration.setProperty(CONFIG_PROPERTY_NAME_STREAM, CONFIG_PROPERTY_VALUE_STREAM_STDLOG);
        } else if (this.printStream == System.out) {
            configuration.setProperty(CONFIG_PROPERTY_NAME_STREAM, CONFIG_PROPERTY_VALUE_STREAM_STDOUT);
        } else if (this.printStream == System.err) {
            configuration.setProperty(CONFIG_PROPERTY_NAME_STREAM, CONFIG_PROPERTY_VALUE_STREAM_STDERR);
        } else {
            configuration.setProperty(CONFIG_PROPERTY_NAME_STREAM, this.printStreamName);
        }
        return configuration;
    }

    @InputPort(name="receivedEvents", description="Receives incoming objects to be logged and forwarded", eventTypes={Object.class})
    public final void inputEvent(Object object) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(this.getName());
        sb.append('(').append(object.getClass().getSimpleName()).append(") ").append(object.toString());
        String record = sb.toString();
        if (this.printStream != null) {
            this.printStream.println(record);
        } else {
            LOG.info(record);
        }
        super.deliver(OUTPUT_PORT_NAME_RELAYED_EVENTS, object);
    }
}

