/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.configuration;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Properties;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;

public final class Configuration
extends Properties {
    private static final long serialVersionUID = 3364877592243422259L;
    private static final Log LOG = LogFactory.getLog(Configuration.class);

    public Configuration() {
        this((Properties)null);
    }

    public Configuration(Properties defaults) {
        super(defaults);
    }

    public final String getStringProperty(String key) {
        String s = super.getProperty(key);
        return s == null ? "" : s.trim();
    }

    public final boolean getBooleanProperty(String key) {
        return Boolean.parseBoolean(this.getStringProperty(key));
    }

    public final int getIntProperty(String key) {
        String s = this.getStringProperty(key);
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            LOG.warn("Error parsing configuration property '" + key + "', found value '" + s + "', using default value 0");
            return 0;
        }
    }

    public final long getLongProperty(String key) {
        String s = this.getStringProperty(key);
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException ex) {
            LOG.warn("Error parsing configuration property '" + key + "', found value '" + s + "', using default value 0");
            return 0L;
        }
    }

    public final String getPathProperty(String key) {
        return Configuration.convertToPath(this.getStringProperty(key));
    }

    public final String[] getStringArrayProperty(String key) {
        return this.getStringArrayProperty(key, "\\|");
    }

    public final String[] getStringArrayProperty(String key, String split) {
        String s = this.getStringProperty(key);
        if (s.length() == 0) {
            return new String[0];
        }
        return s.split(split);
    }

    public static final String toProperty(Object[] values) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            sb.append(values[i]);
            if (i >= values.length - 1) continue;
            sb.append('|');
        }
        return sb.toString();
    }

    public static final String convertToPath(String path) {
        try {
            return new URI(null, null, null, -1, path.replace('\\', '/'), null, null).normalize().toASCIIString();
        }
        catch (URISyntaxException ex) {
            LOG.warn("Failed to parse path: " + path, ex);
            return path;
        }
    }

    public final Configuration getPropertiesStartingWith(String prefix) {
        Configuration configuration = new Configuration(null);
        Enumeration<?> keys = this.propertyNames();
        while (keys.hasMoreElements()) {
            String property = (String)keys.nextElement();
            if (!property.startsWith(prefix)) continue;
            configuration.setProperty(property, super.getProperty(property));
        }
        return configuration;
    }

    public final void setDefaultConfiguration(Configuration defaultConfiguration) throws IllegalAccessException {
        if (this.defaults == null) {
            this.defaults = defaultConfiguration;
        } else if (defaultConfiguration != null) {
            throw new IllegalAccessException();
        }
    }

    @Deprecated
    public final synchronized Object put(Object key, Object value) {
        return super.put(key, value);
    }

    @Deprecated
    public final synchronized Object get(Object key) {
        return super.get(key);
    }

    @Deprecated
    public final String getProperty(String key) {
        return super.getProperty(key);
    }

    @Deprecated
    public final String getProperty(String key, String defaultValue) {
        return super.getProperty(key, defaultValue);
    }
}

