/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.logging;

import java.util.Locale;
import kieker.common.logging.Log;
import kieker.common.logging.LogImplCommonsLogging;
import kieker.common.logging.LogImplJDK14;
import kieker.common.logging.LogImplJUnit;
import kieker.common.logging.LogImplNone;
import kieker.common.logging.LogImplSLF4JLogging;
import kieker.common.logging.LogImplWebguiLogging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogFactory {
    public static final String CUSTOM_LOGGER_JVM = "kieker.common.logging.Log";
    private static final String JVM_LOGGER;
    private static final Logger DETECTED_LOGGER;

    private LogFactory() {
    }

    public static final Log getLog(Class<?> clazz) {
        return LogFactory.getLog(clazz.getName());
    }

    public static final Log getLog(String name) {
        switch (DETECTED_LOGGER) {
            case NONE: {
                return new LogImplNone(name);
            }
            case JDK: {
                return new LogImplJDK14(name);
            }
            case COMMONS: {
                return new LogImplCommonsLogging(name);
            }
            case SLF4J: {
                return new LogImplSLF4JLogging(name);
            }
            case WEBGUI: {
                return new LogImplWebguiLogging(name);
            }
            case JUNIT: {
                return new LogImplJUnit(name);
            }
        }
        return new LogImplJDK14(name);
    }

    private static final Logger detectLogger() {
        if (null != JVM_LOGGER) {
            try {
                return Enum.valueOf(Logger.class, JVM_LOGGER);
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
        try {
            if (Class.forName("org.slf4j.impl.StaticLoggerBinder") != null) {
                return Logger.SLF4J;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            if (Class.forName("org.apache.commons.logging.Log") != null) {
                return Logger.COMMONS;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Logger.JDK;
    }

    static {
        String systemPropertyLogger = System.getProperty(CUSTOM_LOGGER_JVM);
        JVM_LOGGER = null != systemPropertyLogger ? systemPropertyLogger.trim().toUpperCase(Locale.US) : null;
        DETECTED_LOGGER = LogFactory.detectLogger();
        Log log = LogFactory.getLog(LogFactory.class);
        if (null != JVM_LOGGER && !DETECTED_LOGGER.name().equals(JVM_LOGGER)) {
            log.warn("Failed to load Logger with property kieker.common.logging.Log=" + JVM_LOGGER + ", using " + DETECTED_LOGGER.name() + " instead.");
        }
        if (log.isDebugEnabled()) {
            log.debug(DETECTED_LOGGER.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Logger {
        NONE,
        JDK,
        COMMONS,
        SLF4J,
        WEBGUI,
        JUNIT;

    }
}

