/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.logging;

import java.util.logging.Level;
import java.util.logging.Logger;
import kieker.common.logging.Log;

public final class LogImplJDK14
implements Log {
    private final Logger logger;
    private final String name;

    protected LogImplJDK14(String name) {
        this.name = name;
        this.logger = Logger.getLogger(name);
    }

    private final void log(Level level, String message, Throwable t) {
        if (this.logger.isLoggable(level)) {
            String sourceMethod;
            String sourceClass;
            StackTraceElement[] stackArray = new Throwable().getStackTrace();
            if (stackArray.length > 2) {
                sourceClass = stackArray[2].getClassName();
                sourceMethod = stackArray[2].getMethodName();
            } else {
                sourceClass = this.name;
                sourceMethod = "";
            }
            if (t != null) {
                this.logger.logp(level, sourceClass, sourceMethod, message, t);
            } else {
                this.logger.logp(level, sourceClass, sourceMethod, message);
            }
        }
    }

    public final boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    public final void debug(String message) {
        this.log(Level.FINE, message, null);
    }

    public final void debug(String message, Throwable t) {
        this.log(Level.FINE, message, t);
    }

    public final void info(String message) {
        this.log(Level.INFO, message, null);
    }

    public final void info(String message, Throwable t) {
        this.log(Level.INFO, message, t);
    }

    public final void warn(String message) {
        this.log(Level.WARNING, message, null);
    }

    public final void warn(String message, Throwable t) {
        this.log(Level.WARNING, message, t);
    }

    public final void error(String message) {
        this.log(Level.SEVERE, message, null);
    }

    public final void error(String message, Throwable t) {
        this.log(Level.SEVERE, message, t);
    }
}

