/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.controlflow;

import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.IMonitoringRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OperationExecutionRecord
extends AbstractMonitoringRecord
implements IMonitoringRecord.Factory {
    public static final String NO_HOSTNAME = "<default-host>";
    public static final String NO_SESSION_ID = "<no-session-id>";
    public static final long NO_TRACEID = -1L;
    public static final long NO_TIMESTAMP = -1L;
    public static final int NO_EOI_ESS = -1;
    private static final String NO_OPERATION_SIGNATURE = "noOperation";
    private static final long serialVersionUID = 8028082734210614968L;
    private static final Class<?>[] TYPES = new Class[]{String.class, String.class, Long.TYPE, Long.TYPE, Long.TYPE, String.class, Integer.TYPE, Integer.TYPE};
    private final String hostname;
    private final String operationSignature;
    private final String sessionId;
    private final long traceId;
    private final long tin;
    private final long tout;
    private final int eoi;
    private final int ess;

    public OperationExecutionRecord(String operationSignature, String sessionId, long traceId, long tin, long tout, String hostname, int eoi, int ess) {
        this.operationSignature = operationSignature == null ? NO_OPERATION_SIGNATURE : operationSignature;
        this.traceId = traceId;
        this.tin = tin;
        this.tout = tout;
        this.sessionId = sessionId == null ? NO_SESSION_ID : sessionId;
        this.hostname = hostname == null ? NO_HOSTNAME : hostname;
        this.eoi = eoi;
        this.ess = ess;
    }

    public OperationExecutionRecord(Object[] values) {
        AbstractMonitoringRecord.checkArray(values, TYPES);
        this.operationSignature = (String)values[0];
        this.sessionId = (String)values[1];
        this.traceId = (Long)values[2];
        this.tin = (Long)values[3];
        this.tout = (Long)values[4];
        this.hostname = (String)values[5];
        this.eoi = (Integer)values[6];
        this.ess = (Integer)values[7];
    }

    @Override
    public final Object[] toArray() {
        return new Object[]{this.operationSignature, this.sessionId, this.traceId, this.tin, this.tout, this.hostname, this.eoi, this.ess};
    }

    @Override
    @Deprecated
    public void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<?>[] getValueTypes() {
        return (Class[])TYPES.clone();
    }

    public final String getHostname() {
        return this.hostname;
    }

    public String getOperationSignature() {
        return this.operationSignature;
    }

    public final String getSessionId() {
        return this.sessionId;
    }

    public final long getTraceId() {
        return this.traceId;
    }

    public final long getTin() {
        return this.tin;
    }

    public final long getTout() {
        return this.tout;
    }

    public final int getEoi() {
        return this.eoi;
    }

    public final int getEss() {
        return this.ess;
    }
}

