/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.trace;

import kieker.common.record.flow.IObjectRecord;
import kieker.common.record.flow.trace.AbstractTraceEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructionEvent
extends AbstractTraceEvent
implements IObjectRecord {
    private static final long serialVersionUID = -7484030624827825815L;
    private static final Class<?>[] TYPES = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, String.class, Integer.TYPE};
    private static final String NO_CLASSNAME = "<no-classname>";
    private final String classSignature;
    private final int objectId;

    public ConstructionEvent(long timestamp, long traceId, int orderIndex, String className, int objectId) {
        super(timestamp, traceId, orderIndex);
        this.classSignature = className == null ? NO_CLASSNAME : className;
        this.objectId = objectId;
    }

    public ConstructionEvent(Object[] values) {
        super(values, TYPES);
        this.classSignature = (String)values[3];
        this.objectId = (Integer)values[4];
    }

    protected ConstructionEvent(Object[] values, Class<?>[] types) {
        super(values, types);
        this.classSignature = (String)values[3];
        this.objectId = (Integer)values[4];
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.getTimestamp(), this.getTraceId(), this.getOrderIndex(), this.getClassSignature(), this.getObjectId()};
    }

    @Override
    public Class<?>[] getValueTypes() {
        return (Class[])TYPES.clone();
    }

    @Override
    public final String getClassSignature() {
        return this.classSignature;
    }

    @Override
    public final int getObjectId() {
        return this.objectId;
    }
}

