/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.system;

import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.IMonitoringRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CPUUtilizationRecord
extends AbstractMonitoringRecord
implements IMonitoringRecord.Factory {
    private static final long serialVersionUID = 229860008090066333L;
    private static final Class<?>[] TYPES = new Class[]{Long.TYPE, String.class, String.class, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE};
    private static final String DEFAULT_VALUE = "N/A";
    private final long timestamp;
    private final String hostname;
    private final String cpuID;
    private final double user;
    private final double system;
    private final double wait;
    private final double nice;
    private final double irq;
    private final double totalUtilization;
    private final double idle;

    public CPUUtilizationRecord(long timestamp, String hostname, String cpuID, double user, double system, double wait, double nice, double irq, double totalUtilization, double idle) {
        this.timestamp = timestamp;
        this.hostname = hostname == null ? DEFAULT_VALUE : hostname;
        this.cpuID = cpuID == null ? DEFAULT_VALUE : cpuID;
        this.user = user;
        this.system = system;
        this.wait = wait;
        this.nice = nice;
        this.irq = irq;
        this.totalUtilization = totalUtilization;
        this.idle = idle;
    }

    public CPUUtilizationRecord(Object[] values) {
        AbstractMonitoringRecord.checkArray(values, TYPES);
        this.timestamp = (Long)values[0];
        this.hostname = (String)values[1];
        this.cpuID = (String)values[2];
        this.user = (Double)values[3];
        this.system = (Double)values[4];
        this.wait = (Double)values[5];
        this.nice = (Double)values[6];
        this.irq = (Double)values[7];
        this.totalUtilization = (Double)values[8];
        this.idle = (Double)values[9];
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.timestamp, this.hostname, this.cpuID, this.user, this.system, this.wait, this.nice, this.irq, this.totalUtilization, this.idle};
    }

    @Override
    @Deprecated
    public void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<?>[] getValueTypes() {
        return (Class[])TYPES.clone();
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final String getHostname() {
        return this.hostname;
    }

    public final String getCpuID() {
        return this.cpuID;
    }

    public final double getUser() {
        return this.user;
    }

    public final double getSystem() {
        return this.system;
    }

    public final double getWait() {
        return this.wait;
    }

    public final double getNice() {
        return this.nice;
    }

    public final double getIrq() {
        return this.irq;
    }

    public final double getTotalUtilization() {
        return this.totalUtilization;
    }

    public final double getIdle() {
        return this.idle;
    }
}

