/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.core.controller;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicInteger;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.monitoring.core.controller.AbstractController;
import kieker.monitoring.core.controller.IStateController;

public final class StateController
extends AbstractController
implements IStateController {
    private static final Log LOG = LogFactory.getLog(StateController.class);
    private volatile boolean monitoringEnabled;
    private final String name;
    private final String hostname;
    private final AtomicInteger experimentId = new AtomicInteger(0);
    private final boolean debug;

    protected StateController(Configuration configuration) {
        super(configuration);
        this.name = configuration.getStringProperty("kieker.monitoring.name");
        this.experimentId.set(configuration.getIntProperty("kieker.monitoring.initialExperimentId"));
        this.monitoringEnabled = configuration.getBooleanProperty("kieker.monitoring.enabled");
        this.debug = configuration.getBooleanProperty("kieker.monitoring.debug");
        String hostnameTmp = configuration.getStringProperty("kieker.monitoring.hostname");
        if (hostnameTmp.length() == 0) {
            hostnameTmp = "<UNKNOWN>";
            try {
                hostnameTmp = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ex) {
                LOG.warn("Failed to retrieve hostname", ex);
            }
        }
        this.hostname = hostnameTmp;
    }

    protected final void init() {
    }

    protected final void cleanup() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Shutting down State Controller");
        }
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("Status: '");
        if (this.isMonitoringTerminated()) {
            sb.append("terminated");
        } else if (this.isMonitoringEnabled()) {
            sb.append("enabled");
        } else {
            sb.append("disabled");
        }
        sb.append("'\n\tName: '");
        sb.append(this.name);
        sb.append("'; Hostname: '");
        sb.append(this.hostname);
        sb.append("'; experimentID: '");
        sb.append(this.getExperimentId());
        sb.append("'\n");
        return sb.toString();
    }

    public final boolean terminateMonitoring() {
        if (this.monitoringController != null) {
            return this.monitoringController.terminate();
        }
        LOG.warn("Shutting down Monitoring before it is correctly initialized");
        return false;
    }

    public final boolean isMonitoringTerminated() {
        return super.isTerminated();
    }

    public final boolean enableMonitoring() {
        if (this.isMonitoringTerminated()) {
            LOG.error("Refused to enable monitoring because monitoring has been permanently terminated");
            return false;
        }
        LOG.info("Enabling monitoring");
        this.monitoringEnabled = true;
        return true;
    }

    public final boolean disableMonitoring() {
        LOG.info("Disabling monitoring");
        this.monitoringEnabled = false;
        return true;
    }

    public final boolean isMonitoringEnabled() {
        return !super.isTerminated() && this.monitoringEnabled;
    }

    public final String getName() {
        return this.name;
    }

    public final String getHostname() {
        return this.hostname;
    }

    public final int incExperimentId() {
        return this.experimentId.incrementAndGet();
    }

    public final void setExperimentId(int newExperimentID) {
        this.experimentId.set(newExperimentID);
    }

    public final int getExperimentId() {
        return this.experimentId.get();
    }

    public final boolean isDebug() {
        return this.debug;
    }
}

