/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.core.signaturePattern;

import java.util.HashMap;
import java.util.regex.Pattern;
import kieker.monitoring.core.signaturePattern.InvalidPatternException;

public final class PatternParser {
    private PatternParser() {
    }

    public static final Pattern parseToPattern(String strPattern) throws InvalidPatternException {
        String trimPattern = strPattern.trim();
        StringBuilder sb = new StringBuilder();
        if ("*".equals(trimPattern)) {
            sb.append(".*");
        } else {
            String fqName;
            String retType;
            int openingParenthesis = trimPattern.indexOf(40);
            int closingParenthesis = trimPattern.indexOf(41);
            if (openingParenthesis == -1 || closingParenthesis == -1 || openingParenthesis != trimPattern.lastIndexOf(40) || closingParenthesis != trimPattern.lastIndexOf(41) || openingParenthesis > closingParenthesis) {
                throw new InvalidPatternException("Invalid parentheses");
            }
            String[] modifierList = null;
            String[] array = trimPattern.substring(0, openingParenthesis).trim().split("\\s+");
            switch (array.length) {
                case 2: {
                    retType = array[0];
                    fqName = array[1];
                    break;
                }
                case 3: {
                    modifierList = new String[]{array[0]};
                    retType = array[1];
                    fqName = array[2];
                    break;
                }
                case 4: {
                    modifierList = new String[]{array[0], array[1]};
                    retType = array[2];
                    fqName = array[3];
                    break;
                }
                case 5: {
                    modifierList = new String[]{array[0], array[1], array[2]};
                    retType = array[3];
                    fqName = array[4];
                    break;
                }
                case 6: {
                    modifierList = new String[]{array[0], array[1], array[2], array[3]};
                    retType = array[4];
                    fqName = array[5];
                    break;
                }
                case 7: {
                    modifierList = new String[]{array[0], array[1], array[2], array[3], array[4]};
                    retType = array[5];
                    fqName = array[6];
                    break;
                }
                case 8: {
                    modifierList = new String[]{array[0], array[1], array[2], array[3], array[4], array[5]};
                    retType = array[6];
                    fqName = array[7];
                    break;
                }
                default: {
                    throw new InvalidPatternException("invalid pattern");
                }
            }
            int index = fqName.lastIndexOf(46);
            if (index == -1 || index == fqName.length() - 1) {
                throw new InvalidPatternException("Invalid fully qualified type or method name.");
            }
            String fqType = fqName.substring(0, index);
            String methodName = fqName.substring(index + 1);
            String params = trimPattern.substring(openingParenthesis + 1, closingParenthesis).trim();
            int throwsPatternStart = closingParenthesis + 1;
            String throwsPattern = throwsPatternStart < trimPattern.length() ? trimPattern.substring(throwsPatternStart) : null;
            sb.append(PatternParser.parseModifierConstraintList(modifierList));
            sb.append(PatternParser.parseRetType(retType));
            sb.append(PatternParser.parseFQType(fqType));
            sb.append("\\.");
            sb.append(PatternParser.parseMethodName(methodName));
            sb.append("\\(");
            sb.append(PatternParser.parseParameterList(params.trim().split(",")));
            sb.append("\\)");
            sb.append(PatternParser.parseThrowsPattern(throwsPattern));
        }
        return Pattern.compile(sb.toString());
    }

    private static final String parseMethodName(String methodName) throws InvalidPatternException {
        try {
            return PatternParser.parseIdentifier(methodName);
        }
        catch (InvalidPatternException ex) {
            throw new InvalidPatternException("Invalid method name.", ex);
        }
    }

    private static final String parseParameterList(String[] paramList) throws InvalidPatternException {
        int length = paramList.length;
        if (length == 1) {
            if (paramList[0].trim().length() == 0) {
                return "";
            }
            if ("..".equals(paramList[0].trim())) {
                return ".*";
            }
        }
        boolean startsWithDotdot = false;
        StringBuilder sb = new StringBuilder(255);
        if ("..".equals(paramList[0].trim())) {
            sb.append("(((\\s)?[\\p{javaJavaIdentifierPart}\\.])*\\p{javaJavaIdentifierPart}+(\\s)?,)*");
            startsWithDotdot = true;
        } else if ("*".equals(paramList[0].trim())) {
            sb.append("(\\s)?(\\p{javaJavaIdentifierPart})+(\\s)?");
        } else {
            if (paramList[0].trim().length() == 0) {
                throw new InvalidPatternException("Invalid parameter list.");
            }
            try {
                sb.append("(\\s)?");
                sb.append(PatternParser.parseFQType(paramList[0].trim()));
                sb.append("(\\s)?");
            }
            catch (InvalidPatternException ex) {
                throw new InvalidPatternException("Invalid parameter list.", ex);
            }
        }
        int start = 1;
        if (length > 1 && startsWithDotdot) {
            start = 2;
            if ("..".equals(paramList[1].trim())) {
                sb.append("(((\\s)?[\\p{javaJavaIdentifierPart}\\.])*\\p{javaJavaIdentifierPart}+(\\s)?)*");
            } else if ("*".equals(paramList[1].trim())) {
                sb.append("(\\s)?(\\p{javaJavaIdentifierPart})+(\\s)?");
            } else {
                if (paramList[1].trim().length() == 0) {
                    throw new InvalidPatternException("Invalid parameter list.");
                }
                try {
                    sb.append("(\\s)?");
                    sb.append(PatternParser.parseFQType(paramList[1].trim()));
                    sb.append("(\\s)?");
                }
                catch (InvalidPatternException ex) {
                    throw new InvalidPatternException("Invalid parameter list.", ex);
                }
            }
        }
        for (int i = start; i < length; ++i) {
            if ("..".equals(paramList[i].trim())) {
                sb.append("(,((\\s)?[\\p{javaJavaIdentifierPart}\\.])*\\p{javaJavaIdentifierPart}+(\\s)?)*");
                continue;
            }
            if ("*".equals(paramList[i].trim())) {
                sb.append(",(\\s)?(\\p{javaJavaIdentifierPart})+(\\s)?");
                continue;
            }
            if (paramList[i].trim().length() == 0) {
                throw new InvalidPatternException("Invalid parameter list.");
            }
            try {
                sb.append(",(\\s)?");
                sb.append(PatternParser.parseFQType(paramList[i].trim()));
                sb.append("(\\s)?");
                continue;
            }
            catch (InvalidPatternException ex) {
                throw new InvalidPatternException("Invalid parameter list.", ex);
            }
        }
        return sb.toString();
    }

    private static final String parseIdentifier(String identifier) throws InvalidPatternException {
        char[] array = identifier.toCharArray();
        StringBuilder sb = new StringBuilder(128);
        if (Character.isJavaIdentifierStart(array[0])) {
            sb.append(Character.toString(array[0]));
        } else if (array[0] == '*') {
            sb.append("(\\p{javaJavaIdentifierPart})*");
        } else {
            throw new InvalidPatternException("Identifier starts with invalid symbol.");
        }
        for (int i = 1; i < array.length; ++i) {
            if (Character.isJavaIdentifierPart(array[i])) {
                sb.append(Character.toString(array[i]));
                continue;
            }
            if (array[i] == '*') {
                sb.append("(\\p{javaJavaIdentifierPart})*");
                continue;
            }
            throw new InvalidPatternException("Identifier includes invalid symbol.");
        }
        return sb.toString();
    }

    private static final String parseFQType(String fqType) throws InvalidPatternException {
        if (fqType.contains("...") || fqType.endsWith(".") || fqType.length() == 0) {
            throw new InvalidPatternException("Invalid fully qualified type.");
        }
        String[] array = fqType.split("\\.");
        int length = array.length;
        if (length == 1) {
            try {
                return PatternParser.parseIdentifier(fqType);
            }
            catch (InvalidPatternException ex) {
                throw new InvalidPatternException("Invalid fully qualified type.", ex);
            }
        }
        int start = 0;
        StringBuilder sb = new StringBuilder(128);
        if (array[0].length() == 0 && array[1].length() == 0) {
            sb.append("(([\\p{javaJavaIdentifierPart}\\.])*\\.)?");
            start = 2;
        } else if (array[0].length() == 0) {
            throw new InvalidPatternException("Invalid fully qualified type: leading dot");
        }
        for (int i = start; i < length - 1; ++i) {
            if (array[i].length() == 0) {
                sb.append("(([\\p{javaJavaIdentifierPart}\\.])*\\.)?");
                continue;
            }
            try {
                sb.append(PatternParser.parseIdentifier(array[i]));
            }
            catch (InvalidPatternException ex) {
                throw new InvalidPatternException("Invalid fully qualified type.", ex);
            }
            sb.append("\\.");
        }
        try {
            sb.append(PatternParser.parseIdentifier(array[length - 1]));
        }
        catch (InvalidPatternException ex) {
            InvalidPatternException newEx = new InvalidPatternException("Invalid fully qualified type.");
            throw (InvalidPatternException)newEx.initCause(ex);
        }
        return sb.toString();
    }

    private static final String parseRetType(String retType) throws InvalidPatternException {
        if ("new".equals(retType)) {
            return "";
        }
        try {
            return PatternParser.parseFQType(retType) + "\\s";
        }
        catch (InvalidPatternException ex) {
            throw new InvalidPatternException("Invalid return type.", ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String parseModifierConstraintList(String[] modifierList) throws InvalidPatternException {
        if (modifierList == null) {
            return "((public|private|protected)\\s)?(abstract\\s)?(static\\s)?(final\\s)?(synchronized\\s)?(native\\s)?";
        }
        HashMap<String, Integer> allowedModifiersWithOrder = new HashMap<String, Integer>();
        allowedModifiersWithOrder.put("public", 0);
        allowedModifiersWithOrder.put("private", 0);
        allowedModifiersWithOrder.put("protected", 0);
        allowedModifiersWithOrder.put("package", 0);
        allowedModifiersWithOrder.put("abstract", 1);
        allowedModifiersWithOrder.put("non_abstract", 1);
        allowedModifiersWithOrder.put("static", 2);
        allowedModifiersWithOrder.put("non_static", 2);
        allowedModifiersWithOrder.put("final", 3);
        allowedModifiersWithOrder.put("non_final", 3);
        allowedModifiersWithOrder.put("synchronized", 4);
        allowedModifiersWithOrder.put("non_synchronized", 4);
        allowedModifiersWithOrder.put("native", 5);
        allowedModifiersWithOrder.put("non_native", 5);
        int numberOfModifiers = modifierList.length;
        Integer old = -1;
        for (int i = 0; i < numberOfModifiers; ++i) {
            Integer current = (Integer)allowedModifiersWithOrder.get(modifierList[i]);
            if (null == current || current < old) {
                throw new InvalidPatternException("Invalid modifier");
            }
            old = current;
        }
        StringBuilder sb = new StringBuilder();
        if (numberOfModifiers == 1) {
            if ("public".equals(modifierList[0])) {
                sb.append("public\\s(abstract\\s)?(static\\s)?(final\\s)?(synchronized\\s)?(native\\s)?");
                return sb.toString();
            } else if ("private".equals(modifierList[0])) {
                sb.append("private\\s(abstract\\s)?(static\\s)?(final\\s)?(synchronized\\s)?(native\\s)?");
                return sb.toString();
            } else if ("protected".equals(modifierList[0])) {
                sb.append("protected\\s(abstract\\s)?(static\\s)?(final\\s)?(synchronized\\s)?(native\\s)?");
                return sb.toString();
            } else if ("package".equals(modifierList[0])) {
                sb.append("(abstract\\s)?(static\\s)?(final\\s)?(synchronized\\s)?(native\\s)?");
                return sb.toString();
            } else if ("abstract".equals(modifierList[0])) {
                sb.append("((public|private|protected)\\s)?abstract\\s(static\\s)?(final\\s)?(synchronized\\s)?(native\\s)?");
                return sb.toString();
            } else if ("non_abstract".equals(modifierList[0])) {
                sb.append("((public|private|protected)\\s)?(static\\s)?(final\\s)?(synchronized\\s)?(native\\s)?");
                return sb.toString();
            } else if ("static".equals(modifierList[0])) {
                sb.append("((public|private|protected)\\s)?(abstract\\s)?static\\s(final\\s)?(synchronized\\s)?(native\\s)?");
                return sb.toString();
            } else if ("non_static".equals(modifierList[0])) {
                sb.append("((public|private|protected)\\s)?(abstract\\s)?(final\\s)?(synchronized\\s)?(native\\s)?");
                return sb.toString();
            } else if ("final".equals(modifierList[0])) {
                sb.append("((public|private|protected)\\s)?(abstract\\s)?(static\\s)?final\\s(synchronized\\s)?(native\\s)?");
                return sb.toString();
            } else if ("non_final".equals(modifierList[0])) {
                sb.append("((public|private|protected)\\s)?(abstract\\s)?(static\\s)?(synchronized\\s)?(native\\s)?");
                return sb.toString();
            } else if ("synchronized".equals(modifierList[0])) {
                sb.append("((public|private|protected)\\s)?(abstract\\s)?(static\\s)?(final\\s)?synchronized\\s(native\\s)?");
                return sb.toString();
            } else if ("non_synchronized".equals(modifierList[0])) {
                sb.append("((public|private|protected)\\s)?(abstract\\s)?(static\\s)?(final\\s)?(native\\s)?");
                return sb.toString();
            } else if ("native".equals(modifierList[0])) {
                sb.append("((public|private|protected)\\s)?(abstract\\s)?(static\\s)?(final\\s)?(synchronized\\s)?native\\s");
                return sb.toString();
            } else {
                if (!"non_native".equals(modifierList[0])) throw new InvalidPatternException("Invalid modifier.");
                sb.append("((public|private|protected)\\s)?(abstract\\s)?(static\\s)?(final\\s)?(synchronized\\s)?");
            }
            return sb.toString();
        } else if (numberOfModifiers == 2) {
            if ("public".equals(modifierList[0])) {
                sb.append("public\\s");
            } else if ("private".equals(modifierList[0])) {
                sb.append("private\\s");
            } else if ("protected".equals(modifierList[0])) {
                sb.append("protected\\s");
            } else if (!"package".equals(modifierList[0])) {
                sb.append("((public|private|protected)\\s)?");
            }
            if ("abstract".equals(modifierList[0]) || "abstract".equals(modifierList[1])) {
                sb.append("abstract\\s");
            } else if (!"non_abstract".equals(modifierList[0]) && !"non_abstract".equals(modifierList[1])) {
                sb.append("(abstract\\s)?");
            }
            if ("static".equals(modifierList[0]) || "static".equals(modifierList[1])) {
                sb.append("static\\s");
            } else if (!"non_static".equals(modifierList[0]) && !"non_static".equals(modifierList[1])) {
                sb.append("(static\\s)?");
            }
            if ("final".equals(modifierList[0]) || "final".equals(modifierList[1])) {
                sb.append("final\\s");
            } else if (!"non_final".equals(modifierList[0]) && !"non_final".equals(modifierList[1])) {
                sb.append("(final\\s)?");
            }
            if ("synchronized".equals(modifierList[0]) || "synchronized".equals(modifierList[1])) {
                sb.append("synchronized\\s");
            } else if (!"non_synchronized".equals(modifierList[0]) && !"non_synchronized".equals(modifierList[1])) {
                sb.append("(synchronized\\s)?");
            }
            if ("native".equals(modifierList[1])) {
                sb.append("native\\s");
                return sb.toString();
            } else {
                if ("non_native".equals(modifierList[1])) return sb.toString();
                sb.append("(native\\s)?");
            }
            return sb.toString();
        } else if (numberOfModifiers == 3) {
            if ("public".equals(modifierList[0])) {
                sb.append("public\\s");
            } else if ("private".equals(modifierList[0])) {
                sb.append("private\\s");
            } else if ("protected".equals(modifierList[0])) {
                sb.append("protected\\s");
            } else if (!"package".equals(modifierList[0])) {
                sb.append("((public|private|protected)\\s)?");
            }
            if ("abstract".equals(modifierList[0]) || "abstract".equals(modifierList[1])) {
                sb.append("abstract\\s");
            } else if (!"non_abstract".equals(modifierList[0]) && !"non_abstract".equals(modifierList[1])) {
                sb.append("(abstract\\s)?");
            }
            if ("static".equals(modifierList[0]) || "static".equals(modifierList[1]) || "static".equals(modifierList[2])) {
                sb.append("static\\s");
            } else if (!("non_static".equals(modifierList[0]) || "non_static".equals(modifierList[1]) || "non_static".equals(modifierList[2]))) {
                sb.append("(static\\s)?");
            }
            if ("final".equals(modifierList[0]) || "final".equals(modifierList[1]) || "final".equals(modifierList[2])) {
                sb.append("final\\s");
            } else if (!("non_final".equals(modifierList[0]) || "non_final".equals(modifierList[1]) || "non_final".equals(modifierList[2]))) {
                sb.append("(final\\s)?");
            }
            if ("synchronized".equals(modifierList[1]) || "synchronized".equals(modifierList[2])) {
                sb.append("synchronized\\s");
            } else if (!"non_synchronized".equals(modifierList[1]) && !"non_synchronized".equals(modifierList[2])) {
                sb.append("(synchronized\\s)?");
            }
            if ("native".equals(modifierList[2])) {
                sb.append("native\\s");
                return sb.toString();
            } else {
                if ("non_native".equals(modifierList[2])) return sb.toString();
                sb.append("(native\\s)?");
            }
            return sb.toString();
        } else if (numberOfModifiers == 4) {
            if ("public".equals(modifierList[0])) {
                sb.append("public\\s");
            } else if ("private".equals(modifierList[0])) {
                sb.append("private\\s");
            } else if ("protected".equals(modifierList[0])) {
                sb.append("protected\\s");
            } else if (!"package".equals(modifierList[0])) {
                sb.append("((public|private|protected)\\s)?");
            }
            if ("abstract".equals(modifierList[0]) || "abstract".equals(modifierList[1])) {
                sb.append("abstract\\s");
            } else if (!"non_abstract".equals(modifierList[0]) && !"non_abstract".equals(modifierList[1])) {
                sb.append("(abstract\\s)?");
            }
            if ("static".equals(modifierList[0]) || "static".equals(modifierList[1]) || "static".equals(modifierList[2])) {
                sb.append("static\\s");
            } else if (!("non_static".equals(modifierList[0]) || "non_static".equals(modifierList[1]) || "non_static".equals(modifierList[2]))) {
                sb.append("(static\\s)?");
            }
            if ("final".equals(modifierList[1]) || "final".equals(modifierList[2]) || "final".equals(modifierList[3])) {
                sb.append("final\\s");
            } else if (!("non_final".equals(modifierList[1]) || "non_final".equals(modifierList[2]) || "non_final".equals(modifierList[3]))) {
                sb.append("(final\\s)?");
            }
            if ("synchronized".equals(modifierList[2]) || "synchronized".equals(modifierList[3])) {
                sb.append("synchronized\\s");
            } else if (!"non_synchronized".equals(modifierList[2]) && !"non_synchronized".equals(modifierList[3])) {
                sb.append("(synchronized\\s)?");
            }
            if ("native".equals(modifierList[3])) {
                sb.append("native\\s");
                return sb.toString();
            } else {
                if ("non_native".equals(modifierList[3])) return sb.toString();
                sb.append("(native\\s)?");
            }
            return sb.toString();
        } else if (numberOfModifiers == 5) {
            if ("public".equals(modifierList[0])) {
                sb.append("public\\s");
            } else if ("private".equals(modifierList[0])) {
                sb.append("private\\s");
            } else if ("protected".equals(modifierList[0])) {
                sb.append("protected\\s");
            } else if (!"package".equals(modifierList[0])) {
                sb.append("((public|private|protected)\\s)?");
            }
            if ("abstract".equals(modifierList[0]) || "abstract".equals(modifierList[1])) {
                sb.append("abstract\\s");
            } else if (!"non_abstract".equals(modifierList[0]) && !"non_abstract".equals(modifierList[1])) {
                sb.append("(abstract\\s)?");
            }
            if ("static".equals(modifierList[1]) || "static".equals(modifierList[2])) {
                sb.append("static\\s");
            } else if (!"non_static".equals(modifierList[1]) && !"non_static".equals(modifierList[2])) {
                sb.append("(static\\s)?");
            }
            if ("final".equals(modifierList[2]) || "final".equals(modifierList[3])) {
                sb.append("final\\s");
            } else if (!"non_final".equals(modifierList[2]) && !"non_final".equals(modifierList[3])) {
                sb.append("(final\\s)?");
            }
            if ("synchronized".equals(modifierList[3]) || "synchronized".equals(modifierList[4])) {
                sb.append("synchronized\\s");
            } else if (!"non_synchronized".equals(modifierList[3]) && !"non_synchronized".equals(modifierList[4])) {
                sb.append("(synchronized\\s)?");
            }
            if ("native".equals(modifierList[4])) {
                sb.append("native\\s");
                return sb.toString();
            } else {
                if ("non_native".equals(modifierList[4])) return sb.toString();
                sb.append("(native\\s)?");
            }
            return sb.toString();
        } else {
            if (numberOfModifiers != 6) throw new InvalidPatternException("Too many modifier.");
            if ("public".equals(modifierList[0])) {
                sb.append("public\\s");
            } else if ("private".equals(modifierList[0])) {
                sb.append("private\\s");
            } else if ("protected".equals(modifierList[0])) {
                sb.append("protected\\s");
            } else if (!"package".equals(modifierList[0])) {
                throw new InvalidPatternException("Invalid modifier.");
            }
            if ("abstract".equals(modifierList[1])) {
                sb.append("abstract\\s");
            } else if (!"non_abstract".equals(modifierList[1])) {
                throw new InvalidPatternException("Invalid modifier.");
            }
            if ("static".equals(modifierList[2])) {
                sb.append("static\\s");
            } else if (!"non_static".equals(modifierList[2])) {
                throw new InvalidPatternException("Invalid modifier.");
            }
            if ("final".equals(modifierList[3])) {
                sb.append("final\\s");
            } else if (!"non_final".equals(modifierList[3])) {
                throw new InvalidPatternException("Invalid modifier.");
            }
            if ("synchronized".equals(modifierList[4])) {
                sb.append("synchronized\\s");
            } else if (!"non_synchronized".equals(modifierList[4])) {
                throw new InvalidPatternException("Invalid modifier.");
            }
            if ("native".equals(modifierList[5])) {
                sb.append("native\\s");
                return sb.toString();
            } else {
                if ("non_native".equals(modifierList[5])) return sb.toString();
                throw new InvalidPatternException("Invalid modifier.");
            }
        }
    }

    private static String parseThrowsPattern(String throwsPattern) throws InvalidPatternException {
        if (null == throwsPattern) {
            return "";
        }
        String trimThrowsPattern = throwsPattern.trim();
        if (!trimThrowsPattern.startsWith("throws")) {
            throw new InvalidPatternException("Invalid throws pattern.");
        }
        String params = trimThrowsPattern.replaceFirst("throws(\\s+)", "");
        String[] paramList = params.split(",");
        if (paramList.length == 1 && "..".equals(paramList[0])) {
            return "(\\sthrows\\s.*)?";
        }
        try {
            return "\\sthrows\\s".concat(PatternParser.parseParameterList(paramList));
        }
        catch (InvalidPatternException ex) {
            throw new InvalidPatternException("Invalid throws pattern.", ex);
        }
    }
}

