/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.aspectj.flow.constructorExecution;

import kieker.common.record.flow.trace.Trace;
import kieker.common.record.flow.trace.operation.constructor.AfterConstructorEvent;
import kieker.common.record.flow.trace.operation.constructor.AfterConstructorFailedEvent;
import kieker.common.record.flow.trace.operation.constructor.BeforeConstructorEvent;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.core.registry.TraceRegistry;
import kieker.monitoring.probe.aspectj.AbstractAspectJProbe;
import kieker.monitoring.timer.ITimeSource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public abstract class AbstractAspect
extends AbstractAspectJProbe {
    private static final IMonitoringController CTRLINST = MonitoringController.getInstance();
    private static final ITimeSource TIME = CTRLINST.getTimeSource();
    private static final TraceRegistry TRACEREGISTRY = TraceRegistry.INSTANCE;

    @Pointcut
    public abstract /* synthetic */ void monitoredConstructor();

    @Around(value="monitoredConstructor() && this(thisObject) && notWithinKieker()")
    public Object constructor(Object thisObject, ProceedingJoinPoint thisJoinPoint) throws Throwable {
        Object retval;
        boolean newTrace;
        String signature = thisJoinPoint.getSignature().toLongString();
        if (!AbstractAspect.CTRLINST.isProbeActivated(signature)) {
            return thisJoinPoint.proceed();
        }
        Trace trace = AbstractAspect.TRACEREGISTRY.getTrace();
        boolean bl = newTrace = trace == null;
        if (newTrace) {
            trace = AbstractAspect.TRACEREGISTRY.registerTrace();
            AbstractAspect.CTRLINST.newMonitoringRecord(trace);
        }
        long traceId = trace.getTraceId();
        String clazz = thisObject.getClass().getName();
        AbstractAspect.CTRLINST.newMonitoringRecord(new BeforeConstructorEvent(AbstractAspect.TIME.getTime(), traceId, trace.getNextOrderId(), signature, clazz));
        try {
            try {
                retval = thisJoinPoint.proceed();
            }
            catch (Throwable th) {
                AbstractAspect.CTRLINST.newMonitoringRecord(new AfterConstructorFailedEvent(AbstractAspect.TIME.getTime(), traceId, trace.getNextOrderId(), signature, clazz, th.toString()));
                throw th;
            }
        }
        finally {
            if (newTrace) {
                AbstractAspect.TRACEREGISTRY.unregisterTrace();
            }
        }
        AbstractAspect.CTRLINST.newMonitoringRecord(new AfterConstructorEvent(AbstractAspect.TIME.getTime(), traceId, trace.getNextOrderId(), signature, clazz));
        return retval;
    }
}

