/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.servlet;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.monitoring.core.controller.ISamplingController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.core.sampler.ScheduledSamplerJob;
import kieker.monitoring.probe.sigar.SigarSamplerFactory;
import kieker.monitoring.probe.sigar.samplers.CPUsCombinedPercSampler;

public class CPUsCombinedServletContextListener
implements ServletContextListener {
    public static final long DEFAULT_SENSOR_INTERVAL_SECONDS = 15L;
    public static final long DEFAULT_SENSOR_INITIAL_DELAY_SECONDS = 0L;
    private static final String CONTEXT_PARAM_NAME_PREFIX = CPUsCombinedServletContextListener.class.getSimpleName();
    public static final String CONTEXT_PARAM_NAME_SAMPLING_INTERVAL_SECONDS = CONTEXT_PARAM_NAME_PREFIX + ".samplingIntervalSeconds";
    public static final String CONTEXT_PARAM_NAME_INITIAL_SAMPLING_DELAY_SECONDS = CONTEXT_PARAM_NAME_PREFIX + ".initialSamplingDelaySeconds";
    private static final Log LOG = LogFactory.getLog(CPUsCombinedServletContextListener.class);
    private final ISamplingController samplingController = MonitoringController.getInstance();
    private final Collection<ScheduledSamplerJob> samplerJobs = new CopyOnWriteArrayList<ScheduledSamplerJob>();
    private volatile long sensorIntervalSeconds = 15L;
    private volatile long initialDelaySeconds = 0L;

    public void contextDestroyed(ServletContextEvent sce) {
        for (ScheduledSamplerJob s : this.samplerJobs) {
            this.samplingController.removeScheduledSampler(s);
        }
    }

    public void contextInitialized(ServletContextEvent sce) {
        this.initParameters(sce.getServletContext());
        this.initSensors();
    }

    private void initParameters(ServletContext c) {
        if (c == null) {
            LOG.warn("ServletContext == null");
            return;
        }
        this.initialDelaySeconds = this.readLongInitParameter(c, CONTEXT_PARAM_NAME_INITIAL_SAMPLING_DELAY_SECONDS, 0L);
        this.sensorIntervalSeconds = this.readLongInitParameter(c, CONTEXT_PARAM_NAME_SAMPLING_INTERVAL_SECONDS, 15L);
        if (this.sensorIntervalSeconds == 0L) {
            LOG.warn("values for the init-param '" + CONTEXT_PARAM_NAME_SAMPLING_INTERVAL_SECONDS + "' must be >0; found: " + this.sensorIntervalSeconds + ". Using default value: " + 15L);
            this.sensorIntervalSeconds = 15L;
        }
    }

    private long readLongInitParameter(ServletContext c, String paramName, long defaultValue) {
        long val = -1L;
        String valStr = c.getInitParameter(paramName);
        if (valStr != null) {
            try {
                val = Long.parseLong(valStr);
            }
            catch (NumberFormatException exc) {
                val = -1L;
            }
        }
        if (val < 0L) {
            LOG.warn("Invalid or missing value for context-param '" + paramName + "': " + valStr + ". Using default value: " + defaultValue);
            val = defaultValue;
        }
        return val;
    }

    private void initSensors() {
        SigarSamplerFactory sigarFactory = SigarSamplerFactory.INSTANCE;
        CPUsCombinedPercSampler cpuSensor = sigarFactory.createSensorCPUsCombinedPerc();
        ScheduledSamplerJob cpuSensorJob = this.samplingController.schedulePeriodicSampler(cpuSensor, this.initialDelaySeconds, this.sensorIntervalSeconds, TimeUnit.SECONDS);
        this.samplerJobs.add(cpuSensorJob);
    }
}

