/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.controlflow.OperationExecutionRecord;
import kieker.common.util.ClassOperationSignaturePair;
import kieker.common.util.Signature;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.core.registry.ControlFlowRegistry;
import kieker.monitoring.core.registry.SessionRegistry;
import kieker.monitoring.probe.IMonitoringProbe;
import kieker.monitoring.timer.ITimeSource;

public class SessionAndTraceRegistrationFilter
implements Filter,
IMonitoringProbe {
    public static final String CONFIG_PROPERTY_NAME_LOG_FILTER_EXECUTION = "logFilterExecution";
    protected static final IMonitoringController MONITORING_CTRL = MonitoringController.getInstance();
    protected static final SessionRegistry SESSION_REGISTRY = SessionRegistry.INSTANCE;
    protected static final ControlFlowRegistry CF_REGISTRY = ControlFlowRegistry.INSTANCE;
    protected static final ITimeSource TIMESOURCE = MONITORING_CTRL.getTimeSource();
    protected static final String VM_NAME = MONITORING_CTRL.getHostname();
    private static final Log LOG = LogFactory.getLog(SessionAndTraceRegistrationFilter.class);
    private final String filterOperationSignatureString;
    private volatile boolean logFilterExecution = true;

    public SessionAndTraceRegistrationFilter() {
        Signature methodSignature = new Signature("doFilter", new String[]{"public"}, "void", new String[]{ServletRequest.class.getName(), ServletResponse.class.getName(), FilterChain.class.getName()});
        ClassOperationSignaturePair filterOperationSignaturePair = new ClassOperationSignaturePair(SessionAndTraceRegistrationFilter.class.getName(), methodSignature);
        this.filterOperationSignatureString = filterOperationSignaturePair.toString();
    }

    public SessionAndTraceRegistrationFilter(boolean logFilterExecution) {
        this();
        this.logFilterExecution = logFilterExecution;
    }

    protected String getFilterOperationSignatureString() {
        return this.filterOperationSignatureString;
    }

    public void init(FilterConfig config) throws ServletException {
        String valString = config.getInitParameter(CONFIG_PROPERTY_NAME_LOG_FILTER_EXECUTION);
        if (valString != null) {
            this.logFilterExecution = Boolean.parseBoolean(valString);
        } else {
            LOG.warn("Filter configuration 'logFilterExecution' not set. Using the value: " + this.logFilterExecution);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block6: {
            long tout2;
            long tin;
            long traceId;
            String sessionId;
            block7: {
                if (!MONITORING_CTRL.isProbeActivated(this.filterOperationSignatureString)) {
                    chain.doFilter(request, response);
                    return;
                }
                sessionId = this.registerSessionInformation(request);
                traceId = -1L;
                if (this.logFilterExecution) {
                    traceId = CF_REGISTRY.getAndStoreUniqueThreadLocalTraceId();
                    CF_REGISTRY.storeThreadLocalEOI(0);
                    CF_REGISTRY.storeThreadLocalESS(1);
                }
                tin = TIMESOURCE.getTime();
                try {
                    chain.doFilter(request, response);
                    Object var10_7 = null;
                    SESSION_REGISTRY.unsetThreadLocalSessionId();
                    if (!this.logFilterExecution) break block6;
                    tout2 = TIMESOURCE.getTime();
                    if (sessionId != "<no-session-id>") break block7;
                    sessionId = this.registerSessionInformation(request);
                }
                catch (Throwable throwable) {
                    Object var10_8 = null;
                    SESSION_REGISTRY.unsetThreadLocalSessionId();
                    if (this.logFilterExecution) {
                        long tout2 = TIMESOURCE.getTime();
                        if (sessionId == "<no-session-id>") {
                            sessionId = this.registerSessionInformation(request);
                        }
                        MONITORING_CTRL.newMonitoringRecord(new OperationExecutionRecord(this.getFilterOperationSignatureString(), sessionId, traceId, tin, tout2, VM_NAME, 0, 0));
                        CF_REGISTRY.unsetThreadLocalTraceId();
                        CF_REGISTRY.unsetThreadLocalEOI();
                        CF_REGISTRY.unsetThreadLocalESS();
                    }
                    throw throwable;
                }
            }
            MONITORING_CTRL.newMonitoringRecord(new OperationExecutionRecord(this.getFilterOperationSignatureString(), sessionId, traceId, tin, tout2, VM_NAME, 0, 0));
            CF_REGISTRY.unsetThreadLocalTraceId();
            CF_REGISTRY.unsetThreadLocalEOI();
            CF_REGISTRY.unsetThreadLocalESS();
            {
            }
        }
    }

    public void destroy() {
    }

    protected String registerSessionInformation(ServletRequest request) {
        String sessionId = "<no-session-id>";
        if (request == null || !(request instanceof HttpServletRequest)) {
            return sessionId;
        }
        HttpSession session = ((HttpServletRequest)request).getSession(false);
        if (session != null) {
            sessionId = session.getId();
            SESSION_REGISTRY.storeThreadLocalSessionId(sessionId);
        }
        return sessionId;
    }
}

