/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.timer;

import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.monitoring.timer.ITimeSource;

public abstract class AbstractTimeSource
implements ITimeSource {
    private static final Log LOG = LogFactory.getLog(AbstractTimeSource.class);
    protected final Configuration configuration;

    protected AbstractTimeSource(Configuration configuration) {
        try {
            Configuration defaultConfig = this.getDefaultConfiguration();
            if (defaultConfig != null) {
                configuration.setDefaultConfiguration(defaultConfig);
            }
        }
        catch (IllegalAccessException ex) {
            LOG.error("Unable to set timer custom default properties");
        }
        this.configuration = configuration;
    }

    protected Configuration getDefaultConfiguration() {
        return null;
    }

    public abstract String toString();
}

