/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.misc.EmptyRecord;
import kieker.monitoring.core.controller.IMonitoringController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAsyncThread
extends Thread {
    private static final Log LOG = LogFactory.getLog(AbstractAsyncThread.class);
    private static final IMonitoringRecord END_OF_MONITORING_MARKER = new EmptyRecord();
    protected final IMonitoringController monitoringController;
    private final BlockingQueue<IMonitoringRecord> writeQueue;
    private boolean finished;
    private CountDownLatch shutdownLatch;

    public AbstractAsyncThread(IMonitoringController monitoringController, BlockingQueue<IMonitoringRecord> writeQueue) {
        this.writeQueue = writeQueue;
        this.monitoringController = monitoringController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initShutdown(CountDownLatch cdl) {
        AbstractAsyncThread abstractAsyncThread = this;
        synchronized (abstractAsyncThread) {
            this.shutdownLatch = cdl;
            if (this.finished) {
                cdl.countDown();
            }
        }
        try {
            this.writeQueue.put(END_OF_MONITORING_MARKER);
        }
        catch (InterruptedException ex) {
            LOG.error("Error while trying to stop writer thread", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isFinished() {
        AbstractAsyncThread abstractAsyncThread = this;
        synchronized (abstractAsyncThread) {
            return this.finished;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getClass().getName() + " running");
        }
        try {
            BlockingQueue<IMonitoringRecord> writeQueueLocal = this.writeQueue;
            block10: while (true) {
                try {
                    while (true) {
                        IMonitoringRecord monitoringRecord;
                        if ((monitoringRecord = writeQueueLocal.take()) == END_OF_MONITORING_MARKER) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Terminating writer thread, " + writeQueueLocal.size() + " entries remaining");
                            }
                            monitoringRecord = (IMonitoringRecord)writeQueueLocal.poll();
                            while (monitoringRecord != null) {
                                if (monitoringRecord != END_OF_MONITORING_MARKER) {
                                    this.consume(monitoringRecord);
                                }
                                monitoringRecord = (IMonitoringRecord)writeQueueLocal.poll();
                            }
                            this.writeQueue.put(END_OF_MONITORING_MARKER);
                            this.cleanup();
                            AbstractAsyncThread abstractAsyncThread = this;
                            synchronized (abstractAsyncThread) {
                                if (!this.finished && this.shutdownLatch != null) {
                                    this.shutdownLatch.countDown();
                                }
                                this.finished = true;
                                break block10;
                            }
                        }
                        this.consume(monitoringRecord);
                    }
                }
                catch (InterruptedException ex) {
                    continue;
                }
                break;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Writer thread finished");
            }
        }
        catch (Exception ex) {
            LOG.error("Writer thread will halt", ex);
            this.cleanup();
            AbstractAsyncThread abstractAsyncThread = this;
            synchronized (abstractAsyncThread) {
                if (!this.finished && this.shutdownLatch != null) {
                    this.shutdownLatch.countDown();
                }
                this.finished = true;
            }
            this.monitoringController.terminateMonitoring();
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Finished: '");
        sb.append(this.isFinished());
        sb.append('\'');
        return sb.toString();
    }

    protected abstract void consume(IMonitoringRecord var1) throws Exception;

    protected abstract void cleanup();
}

