/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer;

import java.util.Enumeration;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.writer.IMonitoringWriter;

public abstract class AbstractMonitoringWriter
implements IMonitoringWriter {
    private static final Log LOG = LogFactory.getLog(AbstractMonitoringWriter.class);
    protected final Configuration configuration;
    protected IMonitoringController monitoringController;

    protected AbstractMonitoringWriter(Configuration configuration) {
        try {
            Configuration defaultConfiguration = this.getDefaultConfiguration();
            if (defaultConfiguration != null) {
                configuration.setDefaultConfiguration(defaultConfiguration);
            }
        }
        catch (IllegalAccessException ex) {
            LOG.error("Unable to set writer custom default properties");
        }
        this.configuration = configuration;
    }

    protected Configuration getDefaultConfiguration() {
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("Writer: '");
        sb.append(this.getClass().getName());
        sb.append("'\n\tConfiguration:");
        Enumeration<?> keys = this.configuration.propertyNames();
        if (!keys.hasMoreElements()) {
            sb.append("\n\t\tNo Configuration");
        } else {
            while (keys.hasMoreElements()) {
                String property = (String)keys.nextElement();
                sb.append("\n\t\t");
                sb.append(property);
                sb.append("='");
                sb.append(this.configuration.getStringProperty(property));
                sb.append('\'');
            }
        }
        return sb.toString();
    }

    public final void setController(IMonitoringController controller) throws Exception {
        this.monitoringController = controller;
        this.init();
    }

    public final Configuration getConfiguration() {
        return this.configuration;
    }

    protected abstract void init() throws Exception;
}

