/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.filesystem;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import kieker.monitoring.core.registry.RegistryRecord;

public class MappingFileWriter {
    private static final String ENCODING = "UTF-8";
    private final File mappingFile;

    public MappingFileWriter(String path) throws IOException {
        StringBuffer sbm = new StringBuffer(path.length() + 11);
        sbm.append(path).append(File.separatorChar).append("kieker.map");
        String mappingFileFn = sbm.toString();
        this.mappingFile = new File(mappingFileFn);
        if (!this.mappingFile.createNewFile()) {
            throw new IOException("Mapping File '" + mappingFileFn + "' already exists.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(RegistryRecord hashRecord) throws IOException {
        File file = this.mappingFile;
        synchronized (file) {
            PrintWriter pw = null;
            try {
                pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.mappingFile, true), ENCODING));
                pw.write(36);
                pw.write(String.valueOf(hashRecord.getId()));
                pw.write(61);
                pw.write("");
                String value = String.valueOf(hashRecord.getObject());
                pw.write(value);
                pw.write(10);
                if (pw.checkError()) {
                    throw new IOException("Error writing to mappingFile " + this.mappingFile.toString());
                }
                Object var6_5 = null;
                if (pw != null) {
                    pw.close();
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (pw != null) {
                    pw.close();
                }
                throw throwable;
            }
        }
    }
}

