/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.namedRecordPipe;

import kieker.common.configuration.Configuration;
import kieker.common.namedRecordPipe.Broker;
import kieker.common.namedRecordPipe.IPipeWriter;
import kieker.common.namedRecordPipe.Pipe;
import kieker.common.record.IMonitoringRecord;
import kieker.monitoring.writer.AbstractMonitoringWriter;

public final class PipeWriter
extends AbstractMonitoringWriter
implements IPipeWriter {
    private static final String PREFIX = PipeWriter.class.getName() + ".";
    public static final String CONFIG_PIPENAME = PREFIX + "pipeName";
    private final Pipe pipe;

    public PipeWriter(Configuration configuration) {
        super(configuration);
        String pipeName = this.configuration.getStringProperty(CONFIG_PIPENAME);
        if (pipeName.length() == 0) {
            throw new IllegalArgumentException("Invalid or missing value for property '" + CONFIG_PIPENAME + "': '" + pipeName + "'");
        }
        this.pipe = Broker.INSTANCE.acquirePipe(pipeName);
    }

    public final void terminate() {
        if (this.pipe != null) {
            this.pipe.close();
        }
    }

    public final boolean newMonitoringRecord(IMonitoringRecord monitoringRecord) {
        return this.pipe.writeMonitoringRecord(monitoringRecord);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(super.toString());
        sb.append("\n\tConnected to pipe: '");
        sb.append(this.pipe.getName());
        sb.append('\'');
        return sb.toString();
    }

    protected void init() {
    }
}

