/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools;

import java.io.File;
import kieker.analysis.AnalysisController;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public final class KaxRun {
    private static final Log LOG = LogFactory.getLog(KaxRun.class);

    private KaxRun() {
    }

    public static final void main(String[] args) {
        String kaxFilename;
        Options options = new Options();
        Option inputOption = new Option("i", "input", true, "the analysis project file (.kax) loaded");
        inputOption.setRequired(true);
        inputOption.setArgName("filename");
        options.addOption(inputOption);
        try {
            BasicParser parser = new BasicParser();
            CommandLine line = parser.parse(options, args);
            kaxFilename = line.getOptionValue('i');
        }
        catch (ParseException ex) {
            System.out.println(ex.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(KaxRun.class.getName(), options, true);
            return;
        }
        try {
            AnalysisController ctrl = new AnalysisController(new File(kaxFilename));
            ctrl.run();
        }
        catch (Exception ex) {
            LOG.error("Error", ex);
        }
    }
}

