/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxICell;
import com.mxgraph.swing.handler.mxRubberband;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxCellRenderer;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.util.mxXmlUtils;
import com.mxgraph.view.mxGraph;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JFrame;
import kieker.analysis.AnalysisController;
import kieker.analysis.plugin.AbstractPlugin;
import kieker.analysis.plugin.IPlugin;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.analysis.plugin.reader.AbstractReaderPlugin;
import kieker.analysis.repository.AbstractRepository;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KaxViz
extends JFrame {
    private static final long serialVersionUID = 1969467089938687452L;
    private static final Log LOG = LogFactory.getLog(KaxViz.class);
    private static final int FILTER_HEIGHT = 80;
    private static final int FILTER_WIDTH = 200;
    private static final int FILTER_SPACE = 30;
    private static final String STYLE_READER_COLOR = mxConstants.STYLE_FILLCOLOR + "=#A3C592;";
    private static final String STYLE_FILTER_COLOR = mxConstants.STYLE_FILLCOLOR + "=#C3D9FF;";
    private static final String STYLE_REPOSITORY_COLOR = mxConstants.STYLE_FILLCOLOR + "=#EAE385;";
    private static final String STYLE_READER = STYLE_READER_COLOR + mxConstants.STYLE_STROKECOLOR + "=#000000;" + mxConstants.STYLE_FONTCOLOR + "=#000000;";
    private static final String STYLE_FILTER = STYLE_FILTER_COLOR + mxConstants.STYLE_STROKECOLOR + "=#000000;" + mxConstants.STYLE_FONTCOLOR + "=#000000;";
    private static final String STYLE_REPOSITORY = STYLE_REPOSITORY_COLOR + mxConstants.STYLE_ROUNDED + "=1;" + mxConstants.STYLE_STROKECOLOR + "=#000000;" + mxConstants.STYLE_FONTCOLOR + "=#000000;";
    private static final String STYLE_PORT = mxConstants.STYLE_NOLABEL + "=1;" + mxConstants.STYLE_STROKECOLOR + "=#000000;" + mxConstants.STYLE_FONTCOLOR + "=#000000;" + mxConstants.STYLE_FONTSTYLE + "=" + 2 + ";";
    private static final String STYLE_CONNECTION = mxConstants.STYLE_EDGE + "=orthogonalEdgeStyle;";
    private static final String STYLE_CONNECTION_REPOSITORY = mxConstants.STYLE_EDGE + "=orthogonalEdgeStyle;" + mxConstants.STYLE_DASHED + "=1;" + mxConstants.STYLE_FONTCOLOR + "=#000000;" + mxConstants.STYLE_FONTSTYLE + "=" + 2 + ";";
    final transient mxGraph graph;
    private final transient AnalysisController analysisController;

    public KaxViz(String filename, AnalysisController analysisController, final String outFilename) {
        super(analysisController.getProjectName() + " (" + filename + (null != outFilename ? " -> " + outFilename : "") + ")");
        this.analysisController = analysisController;
        if (null != outFilename) {
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    Document doc = mxCellRenderer.createSvgDocument((mxGraph)KaxViz.this.graph, null, (double)1.0, (Color)Color.WHITE, (mxRectangle)KaxViz.this.graph.getGraphBounds());
                    try {
                        mxUtils.writeFile((String)mxXmlUtils.getXml((Node)doc), (String)outFilename);
                    }
                    catch (IOException ex) {
                        LOG.error("Failed to save Visualization of kax-File.", ex);
                    }
                }
            });
        }
        this.graph = new mxGraph();
        this.graph.setCellsLocked(false);
        this.graph.setCellsEditable(false);
        this.graph.setCellsResizable(false);
        this.graph.setCellsDeletable(false);
        this.graph.setCellsCloneable(false);
        this.graph.setCellsDisconnectable(false);
        this.graph.setDropEnabled(false);
        this.graph.setSplitEnabled(false);
        this.graph.setKeepEdgesInForeground(true);
        this.graph.setCollapseToPreferredSize(false);
        this.graph.setAllowNegativeCoordinates(false);
        this.graph.setExtendParents(false);
        this.graph.setExtendParentsOnAdd(false);
        this.graph.setResetEdgesOnConnect(false);
        this.graph.setDisconnectOnMove(false);
        mxGraphComponent graphComponent = new mxGraphComponent(this.graph);
        graphComponent.setConnectable(false);
        graphComponent.setGridVisible(true);
        graphComponent.setFoldingEnabled(false);
        new mxRubberband(graphComponent);
        this.getContentPane().add((Component)graphComponent);
        this.displayGraph();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayGraph() {
        HashMap<AbstractPlugin, mxCell> mapPlugin2Graph = new HashMap<AbstractPlugin, mxCell>();
        HashMap<AbstractFilterPlugin, Map<String, mxCell>> mapPluginInputPorts2Graph = new HashMap<AbstractFilterPlugin, Map<String, mxCell>>();
        HashMap<AbstractPlugin, Map<String, mxCell>> mapPluginOutputPorts2Graph = new HashMap<AbstractPlugin, Map<String, mxCell>>();
        HashMap<AbstractRepository, mxCell> mapRepository2Graph = new HashMap<AbstractRepository, mxCell>();
        this.graph.getModel().beginUpdate();
        try {
            int x = 0;
            for (AbstractReaderPlugin reader : this.analysisController.getReaders()) {
                mxCell mxCell2 = this.createReader(reader, x++);
                mapPlugin2Graph.put(reader, mxCell2);
                mapPluginOutputPorts2Graph.put(reader, this.createOutputPorts(reader, mxCell2, true));
            }
            for (AbstractFilterPlugin filter : this.analysisController.getFilters()) {
                mxCell mxCell3 = this.createFilter(filter, x++);
                mapPlugin2Graph.put(filter, mxCell3);
                mapPluginInputPorts2Graph.put(filter, this.createInputPorts(filter, mxCell3));
                mapPluginOutputPorts2Graph.put(filter, this.createOutputPorts(filter, mxCell3, false));
            }
            for (AbstractRepository repo : this.analysisController.getRepositories()) {
                mxCell mxCell4 = this.createRepository(repo, x++);
                mapRepository2Graph.put(repo, mxCell4);
            }
            LinkedList<AbstractPlugin> allPlugins = new LinkedList<AbstractPlugin>();
            allPlugins.addAll(this.analysisController.getReaders());
            allPlugins.addAll(this.analysisController.getFilters());
            for (IPlugin iPlugin : allPlugins) {
                Map mapOutputPorts2Graph = (Map)mapPluginOutputPorts2Graph.get(iPlugin);
                for (String outputPortName : iPlugin.getAllOutputPortNames()) {
                    for (IPlugin.PluginInputPortReference inputPortReference : iPlugin.getConnectedPlugins(outputPortName)) {
                        mxCell outputPluginCell = (mxCell)mapPlugin2Graph.get(iPlugin);
                        mxCell outputPortCell = (mxCell)mapOutputPorts2Graph.get(outputPortName);
                        IPlugin inputPlugin = inputPortReference.getPlugin();
                        mxCell inputPluginCell = (mxCell)mapPlugin2Graph.get(inputPlugin);
                        String inputPortName = inputPortReference.getInputPortName();
                        mxCell inputPortCell = (mxCell)((Map)mapPluginInputPorts2Graph.get(inputPlugin)).get(inputPortName);
                        this.graph.setCellStyles(mxConstants.STYLE_NOLABEL, "0", new Object[]{inputPortCell, outputPortCell});
                        mxCell edge = (mxCell)this.graph.insertEdge(null, null, (Object)"", (Object)outputPluginCell, (Object)inputPluginCell, STYLE_CONNECTION);
                        edge.setSource((mxICell)outputPortCell);
                        edge.setTarget((mxICell)inputPortCell);
                    }
                }
                for (Map.Entry<String, AbstractRepository> repository : iPlugin.getCurrentRepositories().entrySet()) {
                    mxCell output = (mxCell)mapPlugin2Graph.get(iPlugin);
                    mxCell input = (mxCell)mapRepository2Graph.get(repository.getValue());
                    this.graph.insertEdge(null, null, (Object)repository.getKey(), (Object)output, (Object)input, STYLE_CONNECTION_REPOSITORY);
                }
            }
        }
        finally {
            this.graph.getModel().endUpdate();
        }
    }

    private final Map<String, mxCell> createInputPorts(AbstractPlugin plugin, mxCell vertex) {
        HashMap<String, mxCell> port2graph = new HashMap<String, mxCell>();
        String[] portNames = plugin.getAllInputPortNames();
        for (int i = 0; i < portNames.length; ++i) {
            mxGeometry portGeometry = new mxGeometry(((double)i + 1.0) / (double)(portNames.length + 1), -0.06, 10.0, 10.0);
            portGeometry.setOffset(new mxPoint(0.0, 0.0));
            portGeometry.setRelative(true);
            mxCell port = new mxCell((Object)portNames[i], portGeometry, STYLE_PORT + "spacingTop=3;verticalLabelPosition=bottom;portConstraint=north;" + STYLE_FILTER_COLOR);
            port.setVertex(true);
            this.graph.addCell((Object)port, (Object)vertex);
            port2graph.put(portNames[i], port);
        }
        return port2graph;
    }

    private final Map<String, mxCell> createOutputPorts(AbstractPlugin plugin, mxCell vertex, boolean reader) {
        HashMap<String, mxCell> port2graph = new HashMap<String, mxCell>();
        String[] portNames = plugin.getAllOutputPortNames();
        for (int i = 0; i < portNames.length; ++i) {
            mxGeometry portGeometry = new mxGeometry(((double)i + 1.0) / (double)(portNames.length + 1), 1.06, 10.0, 10.0);
            portGeometry.setOffset(new mxPoint(0.0, -10.0));
            portGeometry.setRelative(true);
            String fillcolor = reader ? STYLE_READER_COLOR : STYLE_FILTER_COLOR;
            mxCell port = new mxCell((Object)portNames[i], portGeometry, STYLE_PORT + "verticalLabelPosition=top;portConstraint=south;" + fillcolor);
            port.setVertex(true);
            this.graph.addCell((Object)port, (Object)vertex);
            port2graph.put(portNames[i], port);
        }
        return port2graph;
    }

    private final mxCell createReader(AbstractReaderPlugin plugin, int c) {
        mxCell vertex = new mxCell((Object)("<<Reader>>\n" + plugin.getName() + " : " + plugin.getPluginName()), new mxGeometry(30.0, (double)(30 + c * 110), 200.0, 80.0), STYLE_READER);
        vertex.setVertex(true);
        this.graph.addCell((Object)vertex);
        return vertex;
    }

    private final mxCell createFilter(AbstractFilterPlugin plugin, int c) {
        mxCell vertex = new mxCell((Object)("<<Filter>>\n" + plugin.getName() + " : " + plugin.getPluginName()), new mxGeometry(30.0, (double)(30 + c * 110), 200.0, 80.0), STYLE_FILTER);
        vertex.setVertex(true);
        this.graph.addCell((Object)vertex);
        return vertex;
    }

    private final mxCell createRepository(AbstractRepository repository, int c) {
        mxCell vertex = new mxCell((Object)("<<Repository>>\n" + repository.getName() + " : " + repository.getRepositoryName()), new mxGeometry(30.0, (double)(30 + c * 110), 200.0, 80.0), STYLE_REPOSITORY);
        vertex.setVertex(true);
        this.graph.addCell((Object)vertex);
        return vertex;
    }

    public static final void main(String[] args) {
        String svgFilename;
        String kaxFilename;
        Options options = new Options();
        Option inputOption = new Option("i", "input", true, "the analysis project file (.kax) loaded");
        inputOption.setRequired(true);
        inputOption.setArgName("filename");
        options.addOption(inputOption);
        Option outputoption = new Option("svg", true, "name of svg saved on close");
        outputoption.setArgName("filename");
        options.addOption(outputoption);
        try {
            BasicParser parser = new BasicParser();
            CommandLine line = parser.parse(options, args);
            kaxFilename = line.getOptionValue('i');
            svgFilename = line.getOptionValue("svg");
        }
        catch (ParseException ex) {
            System.out.println(ex.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(KaxViz.class.getName(), options, true);
            return;
        }
        try {
            KaxViz frame = new KaxViz(kaxFilename, new AnalysisController(new File(kaxFilename)), svgFilename);
            frame.setDefaultCloseOperation(3);
            frame.setExtendedState(6);
            frame.setSize(800, 600);
            frame.setVisible(true);
        }
        catch (Exception ex) {
            LOG.error("Error", ex);
        }
    }
}

