/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter;

import kieker.analysis.exception.AnalysisConfigurationException;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.common.configuration.Configuration;
import kieker.tools.traceAnalysis.filter.AbstractMessageTraceProcessingFilter;
import kieker.tools.traceAnalysis.filter.IGraphProducingFilter;
import kieker.tools.traceAnalysis.filter.visualization.graph.AbstractGraph;
import kieker.tools.traceAnalysis.filter.visualization.graph.AbstractGraphElement;
import kieker.tools.traceAnalysis.filter.visualization.graph.IOriginRetentionPolicy;
import kieker.tools.traceAnalysis.filter.visualization.graph.NoOriginRetentionPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Plugin
public abstract class AbstractGraphProducingFilter<G extends AbstractGraph<?, ?, ?>>
extends AbstractMessageTraceProcessingFilter
implements IGraphProducingFilter<G> {
    private static final String INCOMPATIBLE_RETENTION_ERROR_TEMPLATE = "%s: The current retention policy %s is incompatible with the requested retention policy %s.";
    private final G graph;
    private IOriginRetentionPolicy originRetentionPolicy = NoOriginRetentionPolicy.createInstance();

    public AbstractGraphProducingFilter(Configuration configuration, G graph) {
        super(configuration);
        this.graph = graph;
    }

    @Override
    public Configuration getCurrentConfiguration() {
        return this.configuration;
    }

    public abstract String getConfigurationName();

    @Override
    public void terminate(boolean error) {
        if (!error) {
            this.deliver(this.getGraphOutputPortName(), this.getGraph());
        }
    }

    @Override
    public String getGraphOutputPortName() {
        return "graphs";
    }

    protected G getGraph() {
        return this.graph;
    }

    protected IOriginRetentionPolicy getOriginRetentionPolicy() {
        return this.originRetentionPolicy;
    }

    @Override
    public void requestOriginRetentionPolicy(IOriginRetentionPolicy policy) throws AnalysisConfigurationException {
        if (!this.originRetentionPolicy.isCompatibleWith(policy)) {
            throw new AnalysisConfigurationException(String.format(INCOMPATIBLE_RETENTION_ERROR_TEMPLATE, this, this.originRetentionPolicy, policy));
        }
        this.originRetentionPolicy = this.originRetentionPolicy.uniteWith(policy);
    }

    protected <T> void handleOrigin(AbstractGraphElement<T> element, T origin) {
        this.getOriginRetentionPolicy().handleOrigin(element, origin);
    }
}

