/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter.executionFilter;

import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.common.configuration.Configuration;
import kieker.tools.traceAnalysis.filter.AbstractTraceIdFilter;
import kieker.tools.traceAnalysis.systemModel.Execution;

@Plugin(description="A filter allowing to filter incoming execution objects based on their trace ID", outputPorts={@OutputPort(name="executionsMatchingId", description="Forwards executions with matching trace IDs", eventTypes={Execution.class})})
public class TraceIdFilter
extends AbstractTraceIdFilter {
    public static final String INPUT_PORT_NAME_EXECUTION = "executions";
    public static final String OUTPUT_PORT_NAME_MATCH = "executionsMatchingId";
    public static final String CONFIG_PROPERTY_NAME_SELECT_ALL_TRACES = "selectedAll";
    public static final String CONFIG_PROPERTY_NAME_SELECTED_TRACES = "selectedTraces";

    public TraceIdFilter(Configuration configuration) {
        super(configuration);
    }

    @InputPort(name="executions", description="Receives execution events to be selected by trace ID", eventTypes={Execution.class})
    public void inputExecution(Execution execution) {
        if (super.passId(execution.getTraceId())) {
            super.deliver(OUTPUT_PORT_NAME_MATCH, execution);
        }
    }

    protected String getConfigurationPropertySelectAllTraces() {
        return CONFIG_PROPERTY_NAME_SELECT_ALL_TRACES;
    }

    protected String getConfigurationPropertySelectedTraces() {
        return CONFIG_PROPERTY_NAME_SELECTED_TRACES;
    }
}

