/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter.visualization;

import java.util.Iterator;
import kieker.tools.traceAnalysis.filter.visualization.GraphWriterConfiguration;
import kieker.tools.traceAnalysis.filter.visualization.graph.AbstractGraph;
import kieker.tools.traceAnalysis.filter.visualization.graph.AbstractVertex;
import kieker.tools.traceAnalysis.filter.visualization.graph.AbstractVertexDecoration;
import kieker.tools.traceAnalysis.filter.visualization.graph.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGraphFormatter<G extends AbstractGraph<?, ?, ?>> {
    public String createFormattedRepresentation(AbstractGraph<?, ?, ?> graph, GraphWriterConfiguration configuration) {
        return this.formatGraph(graph, configuration);
    }

    protected abstract String formatGraph(G var1, GraphWriterConfiguration var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFormattedDecorations(AbstractVertex<?, ?, ?> vertex) {
        AbstractVertex<?, ?, ?> abstractVertex = vertex;
        synchronized (abstractVertex) {
            StringBuilder builder = new StringBuilder();
            Iterator<AbstractVertexDecoration> decorationsIter = vertex.getDecorations().iterator();
            while (decorationsIter.hasNext()) {
                String currentDecorationText = decorationsIter.next().createFormattedOutput();
                if (currentDecorationText == null || currentDecorationText.length() == 0) continue;
                builder.append(currentDecorationText);
                if (!decorationsIter.hasNext()) continue;
                builder.append("\\n");
            }
            return builder.toString();
        }
    }

    protected static void formatDecorations(StringBuilder builder, AbstractVertex<?, ?, ?> vertex) {
        String decorations = AbstractGraphFormatter.getFormattedDecorations(vertex);
        if (decorations.length() != 0) {
            builder.append("\\n");
            builder.append(decorations);
        }
    }

    public abstract String getDefaultFileName();

    public static String getDotRepresentation(Color color) {
        return String.format("#%06x", color.getRGB());
    }
}

