/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter.visualization.callTree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kieker.tools.traceAnalysis.filter.visualization.callTree.CallTreeOperationHashKey;
import kieker.tools.traceAnalysis.systemModel.AllocationComponent;
import kieker.tools.traceAnalysis.systemModel.Operation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallTreeNode {
    private final CallTreeNode parent;
    private final List<CallTreeNode> children = Collections.synchronizedList(new ArrayList());
    private final CallTreeOperationHashKey opInfo;

    public CallTreeNode(CallTreeNode parent, CallTreeOperationHashKey opInfo) {
        this.parent = parent;
        if (opInfo == null) {
            throw new IllegalArgumentException("opInfo must not be null");
        }
        this.opInfo = opInfo;
    }

    public final Collection<CallTreeNode> getChildren() {
        return this.children;
    }

    public final CallTreeNode createNewChild(AllocationComponent allocationComponent, Operation operation) {
        CallTreeOperationHashKey k = new CallTreeOperationHashKey(allocationComponent, operation);
        CallTreeNode node = new CallTreeNode(this, k);
        this.children.add(node);
        return node;
    }

    public final CallTreeNode getChild(AllocationComponent allocationComponent, Operation operation) {
        CallTreeOperationHashKey k = new CallTreeOperationHashKey(allocationComponent, operation);
        CallTreeNode node = null;
        for (CallTreeNode n : this.children) {
            if (!n.opInfo.equals(k)) continue;
            node = n;
        }
        if (node == null) {
            node = new CallTreeNode(this, k);
            this.children.add(node);
        }
        return node;
    }

    public final AllocationComponent getAllocationComponent() {
        return this.opInfo.getAllocationComponent();
    }

    public final Operation getOperation() {
        return this.opInfo.getOperation();
    }

    public final CallTreeNode getParent() {
        return this.parent;
    }

    public final boolean isRootNode() {
        return this.parent == null;
    }
}

